/* rc4_enc.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include "rc4.h"

/* if this is defined data[i] is used instead of *data, this is a %20
 * speedup on x86 */
#undef RC4_INDEX

char *RC4_version="\0RC4 part of SSLeay v 0.4.4 17/07/95";

/* RC4 as implemented from a posting from
 * Newsgroups: sci.crypt
 * From: sterndark@netcom.com (David Sterndark)
 * Subject: RC4 Algorithm revealed.
 * Message-ID: <sternCvKL4B.Hyy@netcom.com>
 */

void RC4_set_key(key, len, data)
RC4_KEY *key;
int len;
register unsigned char *data;
	{
        register RC4_INT tmp;
        register unsigned int id1,id2;
        register RC4_INT *d;
        int i;
        
        d=&(key->data[0]);
	for (i=0; i<256; i++)
		d[i]=i;
        key->x = 0;     
        key->y = 0;     
        id1=id2=0;     

#define SK_LOOP(n) { \
		tmp=d[(n)]; \
		id2 = (data[id1] + tmp + id2) & 0xff; \
		if (++id1 == len) id1=0; \
		d[(n)]=d[id2]; \
		d[id2]=tmp; }

	for (i=0; i < 256; i+=4)
		{
		SK_LOOP(i  );
		SK_LOOP(i+1);
		SK_LOOP(i+2);
		SK_LOOP(i+3);
		}
	}
    
void RC4(key, len, indata, outdata)
RC4_KEY *key;
unsigned int len;
unsigned char *indata;
unsigned char *outdata;
	{
        register RC4_INT *d;
        register RC4_INT x,y,tx;
	int i;
        
        x=key->x;     
        y=key->y;     
        d=key->data; 

#define LOOP(in,out) \
		x=((x+1)&0xff); \
		tx=d[x]; \
		y=(tx+y)&0xff; \
		d[x]=d[y]; \
		d[y]=tx; \
		(out) = d[(tx+d[x])&0xff]^ (in);

#ifndef RC4_INDEX
#define RC4_LOOP(a,b)	LOOP(*((a)++),*((b)++))
#else
#define RC4_LOOP(a,b)	LOOP(a[i],b[i])
	indata+=len;
	outdata+=len;
#endif

	i= -len;
        for (;;)
		{               
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		RC4_LOOP(indata,outdata); if (++i == 0) break;
		}               
	key->x=x;     
	key->y=y;
	}
