/* rc4.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_RC4_H
#define HEADER_RC4_H

/* using int types make the structure larger but make the code faster
 * on most boxes I have tested - up to %20 faster. */
#define RC4_INT unsigned char

typedef struct rc4_key_st
	{
	RC4_INT x,y;
	RC4_INT data[256];
	} RC4_KEY;

#ifdef PROTO
void RC4_set_key(RC4_KEY *key, int len, register unsigned char *data);
void RC4(RC4_KEY *key, unsigned int len, unsigned char *indata, unsigned char *outdata);
#else
void RC4_set_key();
void RC4();
#endif

#endif
