/* rc4.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "des.h"
#include "md5.h"
#include "rc4.h"

char *usage[]={
"usage: rc4 args\n",
"\n",
" -in arg         - input file - default stdin\n",
" -out arg        - output file - default stdout\n",
" -key key        - password\n",
NULL
};

int main(argc, argv)
int argc;
char *argv[];
	{
	FILE *in=NULL,*out=NULL;
	char *infile=NULL,*outfile=NULL,*keystr=NULL;
	RC4_KEY key;
	char buf[BUFSIZ];
	int num,badops=0,i;
	char **pp;
	unsigned char md[MD5_DIGEST_LENGTH];

	argc--;
	argv++;
	num=0;
	while (argc >= 1)
		{
		if 	(strcmp(*argv,"-in") == 0)
			{
			if (argc-- < 1) goto bad;
			infile= *(++argv);
			}
		else if (strcmp(*argv,"-out") == 0)
			{
			if (argc-- < 1) goto bad;
			outfile= *(++argv);
			}
		else if (strcmp(*argv,"-key") == 0)
			{
			if (argc-- < 1) goto bad;
			keystr= *(++argv);
			}
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badops=1;
			break;
			}
		argc--;
		argv++;
		}

	if (badops)
		{
bad:
		for (pp=usage; (*pp != NULL); pp++)
			fprintf(stderr,*pp);
		exit(1);
		}

	if (infile == NULL)
		in=stdin;
	else
		{
		in=fopen(infile,"r");
		if (in == NULL)
			{
			perror("open");
			exit(1);
			}

		}
	if (outfile == NULL)
		out=stdout;
	else
		{
		out=fopen(outfile,"w");
		if (out == NULL)
			{
			perror("open");
			exit(1);
			}
		}

	if (keystr == NULL)
		{ /* get key */
		i=des_read_pw_string(buf,BUFSIZ,"Enter RC4 password:",0);
		if (i != 0)
			{
			memset(buf,0,BUFSIZ);
			exit(1);
			}
		keystr=buf;
		}

	MD5((unsigned long)strlen(keystr),(unsigned char *)keystr,md);
	memset(keystr,0,strlen(keystr));
	RC4_set_key(&key,MD5_DIGEST_LENGTH,md);
	
	for(;;)
		{
		i=fread(buf,1,BUFSIZ,in);
		if (i == 0) break;
		if (i < 0)
			{
			perror("read");
			exit(1);
			}
		RC4(&key,(unsigned int)i,(unsigned char *)buf,
			(unsigned char *)buf);
		i=fwrite(buf,(unsigned int)i,1,out);
		if (i != 1)
			{
			perror("write");
			exit(1);
			}
		}
	fclose(out);
	fclose(in);
	exit(0);
	return(1);
	}

