/* md5_dgst.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "md5_locl.h"

char *MD5_version="\0MD5 part of SSLeay v 0.4.4 17/07/95";

/* Implemented from RFC1321 The MD5 Message-Digest Algorithm
 */

#define INIT_DATA_A (unsigned long)0x67452301L
#define INIT_DATA_B (unsigned long)0xefcdab89L
#define INIT_DATA_C (unsigned long)0x98badcfeL
#define INIT_DATA_D (unsigned long)0x10325476L

#ifdef PROTO
static void do_block(MD5_CTX *c, register unsigned long *p);
#else
static void do_block();
#endif

unsigned char *MD5(n, d, md)
unsigned long n;
unsigned char *d;
unsigned char *md;
	{
	MD5_CTX c;
	static unsigned char m[MD5_DIGEST_LENGTH];

	if (md == NULL) md=m;
	MD5Init(&c);
	MD5Update(&c,d,n);
	MD5Final(md,&c);
	return(md);
	}

void MD5Init(c)
MD5_CTX *c;
	{
	c->A=INIT_DATA_A;
	c->B=INIT_DATA_B;
	c->C=INIT_DATA_C;
	c->D=INIT_DATA_D;
	c->Nl=0;
	c->Nh=0;
	c->num=0;
	}

void MD5Update(c, data, len)
MD5_CTX *c;
register unsigned char *data;
unsigned long len;
	{
	register ULONG *p;
	int ew,ec,sw,sc;
	ULONG l;

	if (len == 0) return;

	l=(c->Nl+(len<<3))&0xffffffff;
	/* 95-05-24 eay Fixed a bug with the overflow handling, thanks to
	 * Wei Dai <weidai@eskimo.com> for pointing it out. */
	if (l < c->Nl) /* overflow */
		c->Nh++;
	c->Nh+=(len>>29);
	c->Nl=l;

	if (c->num != 0)
		{
		p=c->data;
		sw=c->num>>2;
		sc=c->num&0x03;

		if ((c->num+len) >= MD5_CBLOCK)
			{
			l= p[sw];
			p_c2l(data,l,sc);
			p[sw++]=l;
			for (; sw<MD5_LBLOCK; sw++)
				{
				c2l(data,l);
				p[sw]=l;
				}
			len-=(MD5_CBLOCK-c->num);

			do_block(c,p);
			c->num=0;
			/* drop through and do the rest */
			}
		else
			{
			int ew,ec;

			c->num+=len;
			if ((sc+len) < 4) /* ugly, add char's to a word */
				{
				l= p[sw];
				p_c2l_p(data,l,sc,len);
				p[sw]=l;
				}
			else
				{
				ew=(c->num>>2);
				ec=(c->num&0x03);
				l= p[sw];
				p_c2l(data,l,sc);
				p[sw++]=l;
				for (; sw < ew; sw++)
					{ c2l(data,l); p[sw]=l; }
				if (ec)
					{
					c2l_p(data,l,ec);
					p[sw]=l;
					}
				}
			return;
			}
		}
	/* we now can process the input data in blocks of MD5_CBLOCK
	 * chars and save the leftovers to c->data. */
	p=c->data;
	while (len >= MD5_CBLOCK)
		{
		for (sw=(MD5_BLOCK/4); sw; sw--)
			{
			c2l(data,l); *(p++)=l;
			c2l(data,l); *(p++)=l;
			c2l(data,l); *(p++)=l;
			c2l(data,l); *(p++)=l;
			}
		p=c->data;
		do_block(c,p);
		len-=MD5_CBLOCK;
		}
	ew=(len>>2);
	ec=(len&0x03);

	for (sw=0; sw < ew; sw++)
		{ c2l(data,l); p[sw]=l; }
	c2l_p(data,l,ec);
	p[sw]=l;
	c->num=len;
	}

static void do_block(c, X)
MD5_CTX *c;
register unsigned long *X;
	{
	register ULONG A,B,C,D;
	int i;

	A=c->A;
	B=c->B;
	C=c->C;
	D=c->D;

	/* Round 0 */
	R0(A,B,C,D,X[ 0], 7,0xd76aa478);
	R0(D,A,B,C,X[ 1],12,0xe8c7b756);
	R0(C,D,A,B,X[ 2],17,0x242070db);
	R0(B,C,D,A,X[ 3],22,0xc1bdceee);
	R0(A,B,C,D,X[ 4], 7,0xf57c0faf);
	R0(D,A,B,C,X[ 5],12,0x4787c62a);
	R0(C,D,A,B,X[ 6],17,0xa8304613);
	R0(B,C,D,A,X[ 7],22,0xfd469501);
	R0(A,B,C,D,X[ 8], 7,0x698098d8);
	R0(D,A,B,C,X[ 9],12,0x8b44f7af);
	R0(C,D,A,B,X[10],17,0xffff5bb1);
	R0(B,C,D,A,X[11],22,0x895cd7be);
	R0(A,B,C,D,X[12], 7,0x6b901122);
	R0(D,A,B,C,X[13],12,0xfd987193);
	R0(C,D,A,B,X[14],17,0xa679438e);
	R0(B,C,D,A,X[15],22,0x49b40821);
	/* Round 1 */
	R1(A,B,C,D,X[ 1], 5,0xf61e2562);
	R1(D,A,B,C,X[ 6], 9,0xc040b340);
	R1(C,D,A,B,X[11],14,0x265e5a51);
	R1(B,C,D,A,X[ 0],20,0xe9b6c7aa);
	R1(A,B,C,D,X[ 5], 5,0xd62f105d);
	R1(D,A,B,C,X[10], 9,0x02441453);
	R1(C,D,A,B,X[15],14,0xd8a1e681);
	R1(B,C,D,A,X[ 4],20,0xe7d3fbc8);
	R1(A,B,C,D,X[ 9], 5,0x21e1cde6);
	R1(D,A,B,C,X[14], 9,0xc33707d6);
	R1(C,D,A,B,X[ 3],14,0xf4d50d87);
	R1(B,C,D,A,X[ 8],20,0x455a14ed);
	R1(A,B,C,D,X[13], 5,0xa9e3e905);
	R1(D,A,B,C,X[ 2], 9,0xfcefa3f8);
	R1(C,D,A,B,X[ 7],14,0x676f02d9);
	R1(B,C,D,A,X[12],20,0x8d2a4c8a);
	/* Round 2 */
	R2(A,B,C,D,X[ 5], 4,0xfffa3942);
	R2(D,A,B,C,X[ 8],11,0x8771f681);
	R2(C,D,A,B,X[11],16,0x6d9d6122);
	R2(B,C,D,A,X[14],23,0xfde5380c);
	R2(A,B,C,D,X[ 1], 4,0xa4beea44);
	R2(D,A,B,C,X[ 4],11,0x4bdecfa9);
	R2(C,D,A,B,X[ 7],16,0xf6bb4b60);
	R2(B,C,D,A,X[10],23,0xbebfbc70);
	R2(A,B,C,D,X[13], 4,0x289b7ec6);
	R2(D,A,B,C,X[ 0],11,0xeaa127fa);
	R2(C,D,A,B,X[ 3],16,0xd4ef3085);
	R2(B,C,D,A,X[ 6],23,0x04881d05);
	R2(A,B,C,D,X[ 9], 4,0xd9d4d039);
	R2(D,A,B,C,X[12],11,0xe6db99e5);
	R2(C,D,A,B,X[15],16,0x1fa27cf8);
	R2(B,C,D,A,X[ 2],23,0xc4ac5665);
	/* Round 3 */
	R3(A,B,C,D,X[ 0], 6,0xf4292244);
	R3(D,A,B,C,X[ 7],10,0x432aff97);
	R3(C,D,A,B,X[14],15,0xab9423a7);
	R3(B,C,D,A,X[ 5],21,0xfc93a039);
	R3(A,B,C,D,X[12], 6,0x655b59c3);
	R3(D,A,B,C,X[ 3],10,0x8f0ccc92);
	R3(C,D,A,B,X[10],15,0xffeff47d);
	R3(B,C,D,A,X[ 1],21,0x85845dd1);
	R3(A,B,C,D,X[ 8], 6,0x6fa87e4f);
	R3(D,A,B,C,X[15],10,0xfe2ce6e0);
	R3(C,D,A,B,X[ 6],15,0xa3014314);
	R3(B,C,D,A,X[13],21,0x4e0811a1);
	R3(A,B,C,D,X[ 4], 6,0xf7537e82);
	R3(D,A,B,C,X[11],10,0xbd3af235);
	R3(C,D,A,B,X[ 2],15,0x2ad7d2bb);
	R3(B,C,D,A,X[ 9],21,0xeb86d391);

	c->A+=A&0xffffffff;
	c->B+=B&0xffffffff;
	c->C+=C&0xffffffff;
	c->D+=D&0xffffffff;
	}

void MD5Final(md, c)
unsigned char *md;
MD5_CTX *c;
	{
	register int i,j;
	register ULONG l;
	register ULONG *p;
	static unsigned char end[4]={0x80,0x00,0x00,0x00};
	unsigned char *cp=end;

	/* c->num should definitly have room for at least one more byte. */
	p=c->data;
	j=c->num;
	i=j>>2;
	l=p[i];
	p_c2l(cp,l,j&0x03);
	p[i]=l;
	i++;
	/* i is the next 'undefined word' */
	if (c->num >= MD5_LAST_BLOCK)
		{
		for (; i<MD5_LBLOCK; i++)
			p[i]=0;
		do_block(c,p);
		i=0;
		}
	for (; i<(MD5_LBLOCK-2); i++)
		p[i]=0;
	p[MD5_LBLOCK-2]=c->Nl;
	p[MD5_LBLOCK-1]=c->Nh;
	do_block(c,p);
	cp=md;
	l=c->A; l2c(l,cp);
	l=c->B; l2c(l,cp);
	l=c->C; l2c(l,cp);
	l=c->D; l2c(l,cp);

	/* clear stuff, do_block may be leaving some stuff on the stack
	 * but I'm not worried :-) */
	c->num=0;
/*	memset((char *)&c,0,sizeof(c));*/
	}

int printit(l)
unsigned long *l;
	{
	int i,ii;

	for (i=0; i<2; i++)
		{
		for (ii=0; ii<8; ii++)
			{
			fprintf(stderr,"%08x ",l[i*8+ii]);
			}
		fprintf(stderr,"\n");
		}
	}
#ifdef undef
#endif
