/* md5.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_MD5_H
#define HEADER_MD5_H

#define MD5_CBLOCK      64
#define MD5_LBLOCK      16
#define MD5_BLOCK       16
#define MD5_LAST_BLOCK  56
#define MD5_LENGTH_BLOCK 8
#define MD5_DIGEST_LENGTH 16

typedef struct MD5state_st
	{
	unsigned long A,B,C,D;
	unsigned long Nl,Nh;
	unsigned long data[MD5_LBLOCK];
	int num;
	} MD5_CTX;

#ifdef PROTO
void MD5Init(MD5_CTX *c);
void MD5Update(MD5_CTX *c, unsigned char *data, unsigned long len);
void MD5Final(unsigned char *md, MD5_CTX *c);
unsigned char *MD5(unsigned long n, unsigned char *d, unsigned char *md);
void MD5_rand_cleanup(void );
void MD5_rand(int num, unsigned char *buf);
void MD5_rand_seed(int num, unsigned char *buf);
#else
void MD5Init();
void MD5Update();
void MD5Final();
unsigned char *MD5();
void MD5_rand_cleanup();
void MD5_rand();
void MD5_rand_seed();
#endif

#endif
