/* md2.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_MD2_H
#define HEADER_MD2_H

#define MD2_DIGEST_LENGTH	16
#define MD2_BLOCK       	16

#define MD2_INT unsigned int

typedef struct MD2state_st
	{
	int num;
	unsigned char data[MD2_BLOCK];
	MD2_INT cksm[MD2_BLOCK];
	MD2_INT state[MD2_BLOCK];
	} MD2_CTX;

#ifdef PROTO
void MD2Init(MD2_CTX *c);
void MD2Update(MD2_CTX *c, register unsigned char *data, unsigned long len);
void MD2Final(unsigned char *md, MD2_CTX *c);
unsigned char *MD2(unsigned long n, unsigned char *d, unsigned char *md);
#else
void MD2Init();
void MD2Update();
void MD2Final();
unsigned char *MD2();
#endif

#endif
