/* lhash.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

/* Header for dynamic hash table routines
 * Author - Eric Young
 */

#ifndef HEADER_LHASH_H
#define HEADER_LHASH_H

typedef struct lhash_node_st
	{
	char *data;
	struct lhash_node_st *next;
#ifndef NO_HASH_COMP
	unsigned long hash;
#endif
	} LHASH_NODE;

typedef struct lhash_st
	{
	LHASH_NODE **b;
	int (*comp)();
	unsigned long (*hash)();
	unsigned long num_nodes;
	unsigned long num_alloc_nodes;
	unsigned long p;
	unsigned long pmax;
	unsigned long up_load; /* load times 256 */
	unsigned long down_load; /* load times 256 */
	unsigned long num_items;

	unsigned long num_expands;
	unsigned long num_expand_reallocs;
	unsigned long num_contracts;
	unsigned long num_contract_reallocs;
	unsigned long num_hash_calls;
	unsigned long num_comp_calls;
	unsigned long num_insert;
	unsigned long num_replace;
	unsigned long num_delete;
	unsigned long num_no_delete;
	unsigned long num_retreve;
	unsigned long num_retreve_miss;
	unsigned long num_hash_comps;
	} LHASH;

#define LH_LOAD_MULT	256

#ifdef PROTO
LHASH *lh_new(unsigned long (*h)(), int (*c)());
void lh_free(LHASH *lh);
char *lh_insert(LHASH *lh, char *data);
char *lh_delete(LHASH *lh, char *data);
char *lh_retrieve(LHASH *lh, char *data);
void lh_stats(LHASH *lh, FILE *out);
void lh_node_stats(LHASH *lh, FILE *out);
void lh_node_usage_stats(LHASH *lh, FILE *out);
void lh_doall(LHASH *lh, void (*func)(char *a));
unsigned long lh_strhash(char *c);
#else
LHASH *lh_new();
void lh_free();
char *lh_insert();
char *lh_delete();
char *lh_retrieve();
void lh_stats();
void lh_node_stats();
void lh_node_usage_stats();
void lh_doall();
unsigned long lh_strhash();
#endif

#endif
