/* err.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_ERR_H
#define HEADER_ERR_H

extern int errno;

/* library */
#define ERR_LIB_NONE		0x00
#define ERR_LIB_SYS		0x10
#define ERR_LIB_DER		0x11
#define ERR_LIB_RSA		0x12
#define ERR_LIB_PEM		0x13
#define ERR_LIB_X509		0x14
#define ERR_LIB_SSL		0x15

#define SYSerr(f,r)		ERR_put_error(ERR_LIB_SYS,f,r)
#define DERerr(f,r)		ERR_put_error(ERR_LIB_DER,f,r)
#define RSAerr(f,r)		ERR_put_error(ERR_LIB_RSA,f,r)
#define PEMerr(f,r)		ERR_put_error(ERR_LIB_PEM,f,r)
#define X509err(f,r)		ERR_put_error(ERR_LIB_X509,f,r)
#define SSLerr(f,r)		ERR_put_error(ERR_LIB_SSL,f,r)

#define ERR_PACK(l,f,r)		((unsigned long)(((l)&0xff)<<24)| \
				(((f)&0xfff)<<12)|(((r)&0xfff)))
#define ERR_GET_LIB(l)		(((l)>>24)&0xff)
#define ERR_GET_FUNC(l)		(((l)>>12)&0xfff)
#define ERR_GET_REASON(l)	((l)&0xfff)
#define ERR_FATAL_ERROR(l)	((l)&ERR_R_FATAL)

/* fuctions are local */
#define ERR_F_FOPEN		1

#define ERR_R_FATAL		0x200
/* reasons */
#define ERR_R_SYS_LIB		0x0101
#define ERR_R_DER_LIB		0x0102
#define ERR_R_RSA_LIB		0x0103
#define ERR_R_PEM_LIB		0x0104
#define ERR_R_X509_LIB		0x0105
#define ERR_R_SSL_LIB		0x0106

/* fatal error */
#define	ERR_R_MALLOC_FAILURE			(0x0107|ERR_R_FATAL)
#define	ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED	(0x0108|ERR_R_FATAL)

typedef struct ERR_string_data_st
	{
	unsigned long error;
	char *string;
	} ERR_STRING_DATA;

#ifdef PROTO
void ERR_put_error(int lib, int func,int reason);
unsigned long ERR_get_error(void );
unsigned long ERR_peek_error(void );
void ERR_clear_error(void );
char *ERR_error_string(unsigned long e);
char *ERR_lib_error_string(unsigned long e);
char *ERR_func_error_string(unsigned long e);
char *ERR_reason_error_string(unsigned long e);
void ERR_print_error_stack(FILE *fp);
void ERR_load_strings(int lib,ERR_STRING_DATA str[]);
void ERR_load_ERR_strings(void );
void ERR_load_crypto_strings(void );
#else
void ERR_put_error();
unsigned long ERR_get_error();
unsigned long ERR_peek_error();
void ERR_clear_error();
char *ERR_error_string();
char *ERR_lib_error_string();
char *ERR_func_error_string();
char *ERR_reason_error_string();
void ERR_print_error_stack();
void ERR_load_strings();
void ERR_load_ERR_strings();
void ERR_load_crypto_strings();
#endif

#endif
