/* err.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <string.h>
#include "lhash.h"
#include "err.h"

#define NUM_ERRORS	10
static unsigned long err_buffer[NUM_ERRORS];
static int top=0,bottom=0;
static LHASH *error_hash=NULL;

#ifdef PROTO
unsigned long err_hash(ERR_STRING_DATA *a);
int err_cmp(ERR_STRING_DATA *a, ERR_STRING_DATA *b);
#else
unsigned long err_hash();
int err_cmp();
#endif

static ERR_STRING_DATA ERR_str_libraries[]=
	{
{ERR_PACK(ERR_LIB_SYS,0,0)		,"system lib"},
{ERR_PACK(ERR_LIB_DER,0,0)		,"DER lib"},
{ERR_PACK(ERR_LIB_RSA,0,0)		,"RSA lib"},
{ERR_PACK(ERR_LIB_PEM,0,0)		,"PEM lib"},
{ERR_PACK(ERR_LIB_X509,0,0)		,"X509 lib"},
{ERR_PACK(ERR_LIB_SSL,0,0)		,"SSL lib"},
{0,NULL},
	};

static ERR_STRING_DATA ERR_str_functs[]=
	{
	{ERR_PACK(0,ERR_F_FOPEN,0),     "fopen"},
	{0,NULL},
	};

static ERR_STRING_DATA ERR_str_reasons[]=
	{
{ERR_R_SYS_LIB				,"system lib"},
{ERR_R_DER_LIB				,"DER lib"},
{ERR_R_RSA_LIB				,"RSA lib"},
{ERR_R_PEM_LIB				,"PEM lib"},
{ERR_R_X509_LIB				,"X509 lib"},
{ERR_R_SSL_LIB				,"SSL lib"},
{ERR_R_MALLOC_FAILURE			,"malloc failure"},
{ERR_R_SHOULD_NOT_HAVE_BEEN_CALLED	,"called a fuction you should not call"},
{0,NULL},
	};


void ERR_load_ERR_strings()
	{
	static int init=1;

	if (init)
		{
		ERR_load_strings(0,ERR_str_libraries);
		ERR_load_strings(0,ERR_str_reasons);
		ERR_load_strings(ERR_LIB_SYS,ERR_str_functs);
		init=0;
		}
	}

void ERR_load_strings(lib,str)
int lib;
ERR_STRING_DATA *str;
	{
	if (error_hash == NULL)
		{
		error_hash=lh_new(err_hash,err_cmp);
		if (error_hash == NULL) return;
		ERR_load_ERR_strings();
		}

	while (str->error)
		{
		str->error|=ERR_PACK(lib,0,0);
		lh_insert(error_hash,(char *)str);
		str++;
		}
	}

void ERR_put_error(lib,func,reason)
int lib,func,reason;
	{
	top=(top+1)%NUM_ERRORS;
	if (top == bottom)
		bottom=(bottom+1)%NUM_ERRORS;
	err_buffer[top]=ERR_PACK(lib,func,reason);
	}

void ERR_clear_error()
	{
	int i;

	for (i=0; i<NUM_ERRORS; i++)
		err_buffer[i]=0;
	top=bottom=0;
	}

unsigned long ERR_peek_error()
	{	
	int i;

	if (bottom == top) return(0);
	i=(bottom+1)%NUM_ERRORS;
	return(err_buffer[i]);
	}

unsigned long ERR_get_error()
	{
	int i;
	unsigned long ret;

	if (bottom == top) return(0);
	i=(bottom+1)%NUM_ERRORS;
	bottom=i;
	ret=err_buffer[i];
	err_buffer[i]=0;
	return(ret);
	}

char *ERR_error_string(e)
unsigned long e;
	{
	static char buf[1024];
	char *ls,*fs,*rs;
	unsigned long l,f,r;
	int i;

	l=ERR_GET_LIB(e);
	f=ERR_GET_FUNC(e);
	r=ERR_GET_REASON(e);

	ls=ERR_lib_error_string(e);
	fs=ERR_func_error_string(e);
	rs=ERR_reason_error_string(e);
	
	sprintf(&(buf[0]),"error:%08lX ",e);
	i=strlen(buf);
	if (ls == NULL)
		sprintf(&(buf[i]),"lib(%ld) ",l);
	else	sprintf(&(buf[i]),"lib(%s) ",ls);
	i=strlen(buf);
	if (fs == NULL)
		sprintf(&(buf[i]),"func(%ld) ",f);
	else	sprintf(&(buf[i]),"func(%s) ",fs);
	i=strlen(buf);
	if (rs == NULL)
		sprintf(&(buf[i]),"reason(%ld)",r);
	else	sprintf(&(buf[i]),"reason(%s)",rs);
	return(buf);
	}

char *ERR_lib_error_string(e)
unsigned long e;
	{
	ERR_STRING_DATA d,*p=NULL;
	unsigned long l;

	l=ERR_GET_LIB(e);
	if (error_hash != NULL)
		{
		d.error=ERR_PACK(l,0,0);
		p=(ERR_STRING_DATA *)lh_retrieve(error_hash,(char *)&d);
		}
	return((p == NULL)?NULL:p->string);
	}

char *ERR_func_error_string(e)
unsigned long e;
	{
	ERR_STRING_DATA d,*p=NULL;
	unsigned long l,f;

	l=ERR_GET_LIB(e);
	f=ERR_GET_FUNC(e);

	if (error_hash != NULL)
		{
		d.error=ERR_PACK(l,f,0);
		p=(ERR_STRING_DATA *)lh_retrieve(error_hash,(char *)&d);
		}
	return((p == NULL)?NULL:p->string);
	}

char *ERR_reason_error_string(e)
unsigned long e;
	{
	ERR_STRING_DATA d,*p=NULL;
	unsigned long l,r;

	l=ERR_GET_LIB(e);
	r=ERR_GET_REASON(e);

	if (error_hash != NULL)
		{
		d.error=ERR_PACK(l,0,r);
		p=(ERR_STRING_DATA *)lh_retrieve(error_hash,(char *)&d);
		if (p == NULL)
			{
			d.error=ERR_PACK(0,0,r);
			p=(ERR_STRING_DATA *)lh_retrieve(error_hash,
				(char *)&d);
			}
		}
	return((p == NULL)?NULL:p->string);
	}

void ERR_print_error_stack(fp)
FILE *fp;
	{
	unsigned long l;

	while ((l=ERR_get_error()))
		fprintf(fp,"%s\n",ERR_error_string(l));
	}

unsigned long err_hash(a)
ERR_STRING_DATA *a;
	{
	long l=a->error;

	l=l* -l;
	return((unsigned long)l);
	}

int err_cmp(a,b)
ERR_STRING_DATA *a,*b;
	{
	return(a->error-b->error);
	}
