/* ede3_enc.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the libdes distribution for more details.
 */

#include "des_locl.h"

int des_ede3_cbc_encrypt(input, output, length, ks1, ks2, ks3, ivec, encrypt)
des_cblock (*input);
des_cblock (*output);
long length;
des_key_schedule ks1;
des_key_schedule ks2;
des_key_schedule ks3;
des_cblock (*ivec);
int encrypt;
	{
	register unsigned long tin0,tin1;
	register unsigned long tout0,tout1,xor0,xor1;
	register unsigned char *in,*out;
	register long l=length;
	unsigned long tin[2];
	unsigned char *iv;

	in=(unsigned char *)input;
	out=(unsigned char *)output;
	iv=(unsigned char *)ivec;

	if (encrypt)
		{
		c2l(iv,tout0);
		c2l(iv,tout1);
		for (; l>0; l-=8)
			{
			if (l >= 8)
				{
				c2l(in,tin0);
				c2l(in,tin1);
				}
			else
				c2ln(in,tin0,tin1,l);
			tin0^=tout0;
			tin1^=tout1;

			IP(tin0,tin1);

			tin[0]=tin0;
			tin[1]=tin1;
			des_encrypt2((unsigned long *)tin,(unsigned long *)tin,
				ks1,DES_ENCRYPT);
			des_encrypt2((unsigned long *)tin,(unsigned long *)tin,
				ks2,DES_DECRYPT);
			des_encrypt2((unsigned long *)tin,(unsigned long *)tin,
				ks3,DES_ENCRYPT);
			tout0=tin[0];
			tout1=tin[1];

			FP(tout1,tout0);

			l2c(tout0,out);
			l2c(tout1,out);
			}
		iv=(unsigned char *)ivec;
		l2c(tout0,iv);
		l2c(tout1,iv);
		}
	else
		{
		c2l(iv,xor0);
		c2l(iv,xor1);
		for (; l>0; l-=8)
			{
			register unsigned long t0,t1;

			c2l(in,tin0);
			c2l(in,tin1);

			t0=tin0;
			t1=tin1;
			IP(tin0,tin1);  

			tin[0]=tin0;
			tin[1]=tin1;
			des_encrypt2((unsigned long *)tin,(unsigned long *)tin,
				ks3,DES_DECRYPT);
			des_encrypt2((unsigned long *)tin,(unsigned long *)tin,
				ks2,DES_ENCRYPT);
			des_encrypt2((unsigned long *)tin,(unsigned long *)tin,
				ks1,DES_DECRYPT);
			tout0=tin[0];
			tout1=tin[1];

			FP(tout1,tout0); /**/

			tout0^=xor0;
			tout1^=xor1;
			if (l >= 8)
				{
				l2c(tout0,out);
				l2c(tout1,out);
				}
			else
				l2cn(tout0,tout1,out,l);
			xor0=t0;
			xor1=t1;
			}
		iv=(unsigned char *)ivec;
		l2c(xor0,iv);
		l2c(xor1,iv);
		}
	tin0=tin1=tout0=tout1=xor0=xor1=0;
	tin[0]=tin[1]=0;
	return(0);
	}

int des_ede2_cbc_encrypt(input, output, length, ks1, ks2, ivec, enc)
des_cblock (*input);
des_cblock (*output);
long length;
des_key_schedule ks1;
des_key_schedule ks2;
des_cblock (*ivec);
int enc;
	{
	return(des_ede3_cbc_encrypt(input,output,length,ks1,ks2,ks1,ivec,enc));
	}
