/* 3ecb_enc.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the libdes distribution for more details.
 */

#include "des_locl.h"

int des_3ecb_encrypt(input, output, ks1, ks2, ks3, encrypt)
des_cblock (*input);
des_cblock (*output);
des_key_schedule ks1;
des_key_schedule ks2;
des_key_schedule ks3;
int encrypt;
	{
	register unsigned long l0,l1;
	register unsigned char *in,*out;
	unsigned long ll[2];

	in=(unsigned char *)input;
	out=(unsigned char *)output;
	c2l(in,l0);
	c2l(in,l1);
	IP(l0,l1);
	ll[0]=l0;
	ll[1]=l1;
	des_encrypt2(ll,ll,ks1,encrypt);
	des_encrypt2(ll,ll,ks2,!encrypt);
	des_encrypt2(ll,ll,ks3,encrypt);
	l0=ll[0];
	l1=ll[1];
	FP(l1,l0);
	l2c(l0,out);
	l2c(l1,out);
	return(0);
	}

int des_2ecb_encrypt(input, output, ks1, ks2, encrypt)
des_cblock (*input);
des_cblock (*output);
des_key_schedule ks1;
des_key_schedule ks2;
int encrypt;
	{
	register unsigned long l0,l1;
	register unsigned char *in,*out;
	unsigned long ll[2];

	in=(unsigned char *)input;
	out=(unsigned char *)output;
	c2l(in,l0);
	c2l(in,l1);
	IP(l0,l1);
	ll[0]=l0;
	ll[1]=l1;
	des_encrypt2(ll,ll,ks1,encrypt);
	des_encrypt2(ll,ll,ks2,!encrypt);
	des_encrypt2(ll,ll,ks1,encrypt);
	l0=ll[0];
	l1=ll[1];
	FP(l1,l0);
	l2c(l0,out);
	l2c(l1,out);
	return(0);
	}
