/* cfb64_enc.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the libdes distribution for more details.
 */

#include "des_locl.h"

/* The input and output encrypted as though 64bit cfb mode is being
 * used.  The extra state information to record how much of the
 * 64bit block we have used is contained in *num;
 */

int des_cfb64_encrypt(in, out, length, schedule, ivec, num, encrypt)
unsigned char *in;
unsigned char *out;
long length;
des_key_schedule schedule;
des_cblock (*ivec);
int *num;
int encrypt;
	{
	register unsigned long v0,v1;
	register long l=length,n=*num;
	unsigned long ti[2];
	unsigned char *iv,c,cc;

	iv=(unsigned char *)ivec;
	if (encrypt)
		{
		while (l--)
			{
			if (n == 0)
				{
				c2l(iv,v0);
				c2l(iv,v1);
				ti[0]=v0;
				ti[1]=v1;
				des_encrypt((unsigned long *)ti,
					(unsigned long *)ti,
					schedule,DES_ENCRYPT);
				iv=(unsigned char *)ivec;
				l2c(ti[0],iv);
				l2c(ti[1],iv);
				iv=(unsigned char *)ivec;
				}
			c= *(in++)^iv[n];
			*(out++)=c;
			iv[n]=c;
			n=(n+1)&0x07;
			}
		}
	else
		{
		while (l--)
			{
			if (n == 0)
				{
				c2l(iv,v0);
				c2l(iv,v1);
				ti[0]=v0;
				ti[1]=v1;
				des_encrypt((unsigned long *)ti,
					(unsigned long *)ti,
					schedule,DES_ENCRYPT);
				iv=(unsigned char *)ivec;
				l2c(ti[0],iv);
				l2c(ti[1],iv);
				iv=(unsigned char *)ivec;
				}
			cc= *(in++);
			c=iv[n];
			iv[n]=cc;
			*(out++)=c^cc;
			n=(n+1)&0x07;
			}
		}
	v0=v1=ti[0]=ti[1]=c=cc=0;
	*num=n;
	return(0);
	}

