/* ssl_trc.c */
/* Copyright (C) 1995 Tim Hudson (tjh@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Tim Hudson's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

/* ssl_trc    - generic portable trace routines to make Eric's life easier
 *
 * 14-Jun-95 tjh    ddt_dump stuff now ... for ssl_print_bytes 
 * 29-Apr-95 tjh    added ssl_fprintf
 * 21-Nov-94 tjh    original coding
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include "ssl_locl.h"
#include "ssl_trc.h"

static char *ssl_trace_prog="SSL";
static int ssl_trace_pid=0;
static int ssl_trace_count=0;
static int ssl_trace_enabled=1;
static int ssl_trace_autoflush=1;
static int ssl_trace_no_header=1;

void SSL_TRACE ( VAR_PLIST( FILE *, fp ) )
    VAR_ALIST
	{
    VAR_BDEFN(args, FILE *, fp);
    char *format;

    static  struct  tm	    *tm_time;
    static  time_t  time_now = 0;

    VAR_INIT(args, FILE *, fp);
    VAR_ARG(args, char *, format);

    /* NULL file pointer is one way to disable the trace */
    if (fp==NULL)
	return;

    time_now = time ( (time_t *)0 );
    tm_time = localtime( &time_now );

    /* 0 means it isn't set or is no longer right */
    if (ssl_trace_pid==0)
	ssl_trace_pid=getpid();

    ssl_trace_count++;

    /* slip a nice header on the front of whatever we are tracing 
* that makes it easy to extra and sort into time-sequenced data
*/
    if (!ssl_trace_no_header)
 fprintf(fp,"%s: [%06d/%09d] %d%02d%02d %02d%02d%02d ",
		      ssl_trace_prog,
		      ssl_trace_pid, ssl_trace_count,
		      tm_time->tm_year,
		      tm_time->tm_mon+1,
		      tm_time->tm_mday,
		      tm_time->tm_hour,
		      tm_time->tm_min,
		      tm_time->tm_sec
		      );

    vfprintf(fp,format,args);

    if (ssl_trace_autoflush)
	fflush(fp);

    VAR_END( args );
    return;
}


#undef TRUNCATE

#ifndef TRACEWRITE
#define TRACEWRITE(X,Y,Z)   write((X),(Y),(Z))
#endif

/*
 *
 * 20-Apr-93 tjh     put - at 8th posn
 * xx-xxx-86 tjh     original coding
 *
 */
#define WIDTH 16

int
ssl_ddt_dump(s,len)
char *s;
int len;
	{
	int i,j,rows,trunc;

   trunc=0;
#ifdef TRUNCATE
   for(;(len>0) && (s[len-1]==' ')||(s[len-1]=='\0');len--) 
	    trunc++;
#endif

	rows=(len/WIDTH);
	if ((rows*WIDTH)<len)
	  rows++;
	for(i=0;i<rows;i++) {
	  printf("%04x - ",i*WIDTH);
	  for(j=0;j<WIDTH;j++) {
		if (((i*WIDTH)+j)>=len)
			printf("   ");
		else
			printf("%02x%c",(char)*((char *)(s)+i*WIDTH+j)&0xff,j==7?'-':' ');
	  }
	  printf("  ");
	  for(j=0;j<WIDTH;j++) {
	    char ch;

	    if (((i*WIDTH)+j)>=len)
	      break;
	    ch=((char)*((char *)(s)+i*WIDTH+j)&0xff);
/*
	    printf("%c",isprint(ch)?ch:'.');
*/
	    printf("%c",((ch>=' ')&&(ch<='~'))?ch:'.');
	  }
	  printf("\n");
	}

#ifdef TRUNCATE
	if (trunc!=0) 
	    printf("%04x - <SPACES/NULS>\n",len+trunc);
#endif

}

int
ssl_ddt_dump_fd(fd,s,len)
int fd;
char *s;
int len;
	{
  static char buf[160+1],tmp[20];
  int i,j,rows,trunc;
  unsigned char ch;

  trunc=0;

#ifdef TRUNCATE
  for(;(len>0) && (s[len-1]==' ')||(s[len-1]=='\0');len--) 
    trunc++;
#endif

  rows=(len/WIDTH);
  if ((rows*WIDTH)<len)
    rows++;
  for(i=0;i<rows;i++) {
    buf[0]='\0';	/* start with empty string */
    sprintf(tmp,"%04x - ",i*WIDTH);
    strcpy(buf,tmp);
    for(j=0;j<WIDTH;j++) {
 if (((i*WIDTH)+j)>=len) {
	strcat(buf,"   ");
 } else {
   ch=((unsigned char)*((char *)(s)+i*WIDTH+j)) & 0xff;
	sprintf(tmp,"%02x%c",ch,j==7?'-':' ');
   strcat(buf,tmp);
 }
    }
    strcat(buf,"  ");
    for(j=0;j<WIDTH;j++) {
 if (((i*WIDTH)+j)>=len)
	break;
 ch=((unsigned char)*((char *)(s)+i*WIDTH+j)) & 0xff;
 sprintf(tmp,"%c",((ch>=' ')&&(ch<='~'))?ch:'.');
 strcat(buf,tmp);
    }
    strcat(buf,"\n");
    /* if this is the last call then update the ddt_dump thing so that
* we will move the selection point in the debug window 
*/
    TRACEWRITE(fd,(char *)buf,strlen(buf));
  }
#ifdef TRUNCATE
  if (trunc!=0) {
    sprintf(buf,"%04x - <SPACES/NULS>\n",len+trunc);
    TRACEWRITE(fd,(char *)buf,strlen(buf));
  }
#endif
  return 0;
}


#ifndef LOCAL_TEST
int SSL_fprintf ( VAR_PLIST( SSL *, ssl_con ) )
    VAR_ALIST
	{
    VAR_BDEFN(args, SSL *, ssl_con);
    FILE *fp;
    char *format;
    static char hugebuf[10240];        /* 10k in one chunk is the limit */

    VAR_INIT(args, SSL *, ssl_con);
    VAR_ARG(args, FILE *, fp);
    VAR_ARG(args, char *, format);

    if (ssl_con==NULL)
   return vfprintf(fp,format,args);

    hugebuf[0]='\0';

#ifdef sun
    _doprnt(hugebuf,format,args);
#else /* !sun */
    vsprintf(hugebuf,format,args);
#endif /* sun */

    SSL_write(ssl_con,hugebuf,strlen(hugebuf));

    VAR_END( args );
    return 0;
}
#endif /* !LOCAL_TEST */


#ifdef LOCAL_TEST

#include <stdio.h>

int
main(argc,argv)
int argc;
char *argv[];
	{
    SSL_TRACE(stderr,"Hello there\n");
    SSL_TRACE(stderr,"Hello %s %d there %x\n","tjh",1,16);
    SSL_TRACE(NULL,"Should not see this\n");
    SSL_TRACE(stderr,"Should not see this (twice - only once)\n");

    fflush(stderr);

    exit(0);

}

#endif

