/* ssl_rc4.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 *
 * Andreas Bogk <bogk@inf.fu-berlin.de> send patches for IDEA 
 * just before I released this 'update'.  His code was amazingly
 * similar to mine.  So a many thank for the effort but unfortunatly since my
 * code was in the 'distribution' first, I'll ship my version.
 * Sorry Andreas :-).
 */

#include <stdio.h>
#include "idea.h"
#include "md5.h"
#include "ssl_locl.h"
#include "ssl_idea.h"

int ssl_enc_idea_cbc_init(s, client)
SSL *s;
int client;
	{
	MD5_CTX md5s;
	unsigned char *md5d1,*md5d2;
	IDEA_CBC_STATE *is;
	IDEA_KEY_SCHEDULE id;
	CONN *c;

	if (s->crypt_state == NULL)
		s->crypt_state=(char *)malloc(sizeof(IDEA_CBC_STATE));
	if (s->crypt_state == NULL) goto err;
	is=(IDEA_CBC_STATE *)s->crypt_state;

	c=s->conn;
	if (c->key_material != NULL) free(c->key_material);
	md5d1=c->key_material=(unsigned char *)malloc(MD5_DIGEST_LENGTH*2);
	if (c->key_material == NULL) goto err;
	c->key_material_length=MD5_DIGEST_LENGTH*2;
	md5d2=&(c->key_material[MD5_DIGEST_LENGTH]);
	
	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,(unsigned char *)"0",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d1,&md5s);

	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,(unsigned char *)"1",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d2,&md5s);

	if (client)
		{
		idea_encrypt_key(md5d1,&id);
		idea_decrypt_key(&id,&(is->idea_read_ks));
		idea_encrypt_key(md5d2,&(is->idea_write_ks));
		s->read_key=md5d1;
		s->write_key=md5d2;
		}
	else
		{
		idea_encrypt_key(md5d2,&id);
		idea_decrypt_key(&id,&(is->idea_read_ks));
		idea_encrypt_key(md5d1,&(is->idea_write_ks));
		s->read_key=md5d2;
		s->write_key=md5d1;
		}

	memset((char *)&(id.data[0][0]),0,sizeof(id));
	memcpy(is->read_iv,s->conn->key_arg,IDEA_BLOCK);
	memcpy(is->write_iv,s->conn->key_arg,IDEA_BLOCK);
	return(1);
err:
	SSL_errno=SSL_ERRCODE(SSL_F_SSL_ENC_IDEA_CBC_INIT,SSL_R_OUT_OF_MEMORY);
	return(0);
	}

/* read/writes from s->mac_data using length for encrypt and decrypt.
 * it sets the s->padding, s->length and s->pad_data ptr if we
 * are encrypting */
void ssl_enc_idea_cbc(s)
SSL *s;
	{
	IDEA_CBC_STATE *is;
	unsigned long l;

	is=(IDEA_CBC_STATE *)s->crypt_state;
	l=s->length;
	l=(l+(IDEA_BLOCK-1))/IDEA_BLOCK*IDEA_BLOCK;

#ifdef IDEA_DEBUG
	SSL_TRACE(SSL_ERR,"IDEA CBC length=%d\n",s->length);
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif

	if (s->send)
		idea_cbc_encrypt(s->mac_data,s->mac_data,(long)l,
			&(is->idea_write_ks),is->write_iv,IDEA_ENCRYPT);
	else
		idea_cbc_encrypt(s->mac_data,s->mac_data,(long)l,
			&(is->idea_read_ks),is->read_iv,IDEA_DECRYPT);

#ifdef IDEA_DEBUG
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif

	}

