/* ssl_err.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_SSL_ERR_H
#define HEADER_SSL_ERR_H

#define SSL_NO_ERROR				0

#define SSL_F_SSL_NEW				1
#define SSL_F_SSL_CERT_NEW			2
#define SSL_F_GET_SERVER_HELLO			3
#define SSL_F_CLIENT_HELLO			4
#define SSL_F_CLIENT_MASTER_KEY			5
#define SSL_F_CLIENT_CERTIFICATE		6
#define SSL_F_GET_SERVER_VERIFY			7
#define SSL_F_GET_SERVER_FINISHED		8
#define SSL_F_GET_NEW_CONN			9
#define SSL_F_SSL_ENC_DES_CBC_INIT		10
#define SSL_F_SSL_ENC_DES_EDE3_CBC_INIT		11
#define SSL_F_SSL_ENC_DES_CFB_INIT		12
#define SSL_F_SSL_ENC_NULL_INIT			13
#define SSL_F_SSL_ENC_RC4_INIT			14
#define SSL_F_SSL_CERT_RSA_PUBLIC_ENCRYPT	15
#define SSL_F_SSL_CERT_RSA_PRIVATE_ENCRYPT	16
#define SSL_F_SSL_CERT_RSA_PUBLIC_DECRYPT	17
#define SSL_F_SSL_CERT_RSA_PRIVATE_DECRYPT	18
#define SSL_F_SSL_USE_CERTIFICATE		19
#define SSL_F_SSL_USE_CERTIFICATE_DER		20
#define SSL_F_SSL_USE_RSAPRIVATEKEY		21
#define SSL_F_SSL_USE_RSAPRIVATEKEY_DER		22
#define SSL_F_SSL_EXTRACT_PUBLIC_KEY		23
#define SSL_F_SSL_SET_CERTIFICATE		24
#define SSL_F_GET_CLIENT_MASTER_KEY		30
#define SSL_F_GET_CLIENT_HELLO			31
#define SSL_F_SERVER_HELLO			32
#define SSL_F_GET_CLIENT_FINISHED		33
#define SSL_F_REQUEST_CERTIFICATE		34
#define SSL_F_SSL_ENC_IDEA_CBC_INIT		35
#define SSL_F_SSL_USE_RSAPRIVATEKEY_FILE	37

#define SSL_R_OUT_OF_MEMORY			1
#define SSL_R_VALUE_NOT_SET			2
#define SSL_R_SHORT_READ			3
#define SSL_R_READ_WRONG_PACKET_TYPE		4
#define SSL_R_NO_CIPHER_LIST			5
#define SSL_R_NO_CIPHER_MATCH			6
#define SSL_R_BAD_INTERNEL_ERROR		7
#define SSL_R_PUBLIC_KEY_DECRYPT_ERROR		8
#define SSL_R_CHALLENGE_IS_DIFFERENT		9
#define SSL_R_SESSION_ID_IS_DIFFERENT		10
#define SSL_R_NO_PUBLICKEY			11
#define SSL_R_NO_PRIVATEKEY			12
#define SSL_R_ERRNO				13
#define SSL_R_X509				14
#define SSL_R_BAD_X509_FILETYPE			15
#define SSL_R_PEM				16
#define SSL_R_RSA				17
#define SSL_R_DER				18
#define SSL_R_PEER_ERROR			19
#define SSL_R_BAD_SESSION_ID_LENGTH		20
#define SSL_R_NO_CERTIFICATE_SPECIFIED		21
#define SSL_R_CONNECTION_ID_IS_DIFFERENT	22
#define SSL_R_BAD_CHECKSUM			23
#define SSL_R_BAD_CHECKSUM_DECODE		24
#define SSL_R_PEER_DID_NOT_RETURN_A_CERT 	25

#define SSL_ERRCODE(f,r)	(((f)<<8)|(r))
#define SSL_ERRFUNC(f)		((f)>>8)&0xff
#define SSL_ERRTYPE(f)		((f)&0xff)

#endif
