/* ssl_err.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "der.h"
#include "X509.h"
#include "PEM.h"
#include "ssl_locl.h"
#include "ssl_err.h"

/* NOTE: these error strings are a direct mapping of the #define to a
 * string.  This will change as I get time to put a more meaningfull
 * error messages in :-)
 */
char *SSL_error_func_string(n)
int n;
	{
	static char buf[100];

	n=SSL_ERRFUNC(n);
	switch (n)
		{
	case SSL_F_SSL_NEW:
		return("SSL_NEW");
	case SSL_F_SSL_CERT_NEW:
		return("SSL_CERT_NEW");
	case SSL_F_GET_SERVER_HELLO:
		return("GET_SERVER_HELLO");
	case SSL_F_CLIENT_HELLO:
		return("CLIENT_HELLO");
	case SSL_F_CLIENT_MASTER_KEY:
		return("CLIENT_MASTER_KEY");
	case SSL_F_CLIENT_CERTIFICATE:
		return("CLIENT_CERTIFICATE");
	case SSL_F_GET_SERVER_VERIFY:
		return("GET_SERVER_VERIFY");
	case SSL_F_GET_SERVER_FINISHED:
		return("GET_SERVER_FINISHED");
	case SSL_F_GET_NEW_CONN:
		return("GET_NEW_CONN");
	case SSL_F_SSL_ENC_DES_CBC_INIT:
		return("SSL_ENC_DES_CBC_INIT");
	case SSL_F_SSL_ENC_DES_EDE3_CBC_INIT:
		return("SSL_ENC_DES_EDE3_CBC_INIT");
	case SSL_F_SSL_ENC_DES_CFB_INIT:
		return("SSL_ENC_DES_CFB_INIT");
	case SSL_F_SSL_ENC_NULL_INIT:
		return("SSL_ENC_NULL_INIT");
	case SSL_F_SSL_ENC_RC4_INIT:
		return("SSL_ENC_RC4_INIT");
	case SSL_F_SSL_CERT_RSA_PUBLIC_ENCRYPT:
		return("SSL_CERT_RSA_PUBLIC_ENCRYPT");
	case SSL_F_SSL_CERT_RSA_PRIVATE_ENCRYPT:
		return("SSL_CERT_RSA_PRIVATE_ENCRYPT");
	case SSL_F_SSL_CERT_RSA_PUBLIC_DECRYPT:
		return("SSL_CERT_RSA_PUBLIC_DECRYPT");
	case SSL_F_SSL_CERT_RSA_PRIVATE_DECRYPT:
		return("SSL_CERT_RSA_PRIVATE_DECRYPT");
	case SSL_F_SSL_USE_CERTIFICATE:
		return("SSL_USE_CERTIFICATE");
	case SSL_F_SSL_USE_CERTIFICATE_DER:
		return("SSL_USE_CERTIFICATE_DER");
	case SSL_F_SSL_USE_RSAPRIVATEKEY:
		return("SSL_USE_RSAPRIVATEKEY");
	case SSL_F_SSL_USE_RSAPRIVATEKEY_DER:
		return("SSL_USE_RSAPRIVATEKEY_DER");
	case SSL_F_SSL_EXTRACT_PUBLIC_KEY:
		return("SSL_EXTRACT_PUBLIC_KEY");
	case SSL_F_SSL_SET_CERTIFICATE:
		return("SSL_SET_CERTIFICATE");
	case SSL_F_GET_CLIENT_MASTER_KEY:
		return("GET_CLIENT_MASTER_KEY");
	case SSL_F_GET_CLIENT_HELLO:
		return("GET_CLIENT_HELLO");
	case SSL_F_SERVER_HELLO:
		return("SERVER_HELLO");
	case SSL_F_GET_CLIENT_FINISHED:
		return("GET_CLIENT_FINISHED");
	case SSL_F_REQUEST_CERTIFICATE:
		return("REQUEST_CERTIFICATE");
	case SSL_F_SSL_ENC_IDEA_CBC_INIT:
		return("SSL_ENC_IDEA_CBC_INIT");
	default:
		sprintf(buf,"SSL error function number %d",n);
		return(buf);
		}
	}

char *SSL_error_string(n)
int n;
	{
	static char buf[100];

	n=SSL_ERRTYPE(n);
	switch (n)
		{
	case SSL_R_ERRNO:
		return("SYSTEM_ERROR");
	case SSL_R_X509:
		return(X509_error_string(X509_errno));
	case SSL_R_PEM:
		return(X509_error_string(PEM_errno));
	case SSL_R_RSA:
		return(X509_error_string(RSA_errno));
	case SSL_R_DER:
		return(X509_error_string(DER_errno));
	case SSL_R_OUT_OF_MEMORY:
		return("SSL_OUT_OF_MEMORY");
	case SSL_R_VALUE_NOT_SET:
		return("SSL_VALUE_NOT_SET");
	case SSL_R_SHORT_READ:
		return("SSL_SHORT_READ");
	case SSL_R_READ_WRONG_PACKET_TYPE:
		return("SSL_READ_WRONG_PACKET_TYPE");
	case SSL_R_NO_CIPHER_LIST:
		return("SSL_NO_CIPHER_LIST");
	case SSL_R_NO_CIPHER_MATCH:
		return("SSL_NO_CIPHER_MATCH");
	case SSL_R_BAD_INTERNEL_ERROR:
		return("SSL_BAD_INTERNEL_ERROR");
	case SSL_R_PUBLIC_KEY_DECRYPT_ERROR:
		return("SSL_PUBLIC_KEY_DECRYPT_ERROR");
	case SSL_R_CHALLENGE_IS_DIFFERENT:
		return("SSL_CHALLENGE_IS_DIFFERENT");
	case SSL_R_SESSION_ID_IS_DIFFERENT:
		return("SSL_SESSION_ID_IS_DIFFERENT");
	case SSL_R_NO_PUBLICKEY:
		return("SSL_NO_PUBLICKEY");
	case SSL_R_NO_PRIVATEKEY:
		return("SSL_NO_PRIVATEKEY");
	case SSL_R_BAD_X509_FILETYPE:
		return("SSL_BAD_X509_FILETYPE");
	case SSL_R_PEER_ERROR:
		return("SSL_PEER_ERROR");
	case SSL_R_BAD_SESSION_ID_LENGTH:
		return("SSL_BAD_SESSION_ID_LENGTH");
	case SSL_R_NO_CERTIFICATE_SPECIFIED:
		return("SSL_NO_CERTIFICATE_SPECIFIED");
	case SSL_R_CONNECTION_ID_IS_DIFFERENT:
		return("SSL_CONNECTION_ID_IS_DIFFERENT");
	case SSL_R_BAD_CHECKSUM:
		return("SSL_BAD_CHECKSUM");
	case SSL_R_BAD_CHECKSUM_DECODE:
		return("SSL_BAD_CHECKSUM_DECODE");
	case SSL_R_PEER_DID_NOT_RETURN_A_CERT:
		return("client end did not return a certificate");
	default:
		sprintf(buf,"SSL error number %d",n);
		return(buf);
		}
	}
