/* ssl_des.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "des.h"
#include "md5.h"
#include "ssl_locl.h"
#include "ssl_des.h"

int ssl_enc_des_cbc_init(s, client)
SSL *s;
int client;
	{
	MD5_CTX md5s;
	unsigned char md5d[MD5_DIGEST_LENGTH];
	DES_CBC_STATE *ds;
	CONN *c;

	if (s->crypt_state == NULL)
		s->crypt_state=(char *)malloc(sizeof(DES_CBC_STATE));
	if (s->crypt_state == NULL) goto err;

	ds=(DES_CBC_STATE *)s->crypt_state;

	c=s->conn;
	if (c->key_material != NULL) free(c->key_material);
	c->key_material=(unsigned char *)malloc(MD5_DIGEST_LENGTH);
	if (c->key_material == NULL) goto err;
	c->key_material_length=MD5_DIGEST_LENGTH;

	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,(unsigned char *)"0",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d,&md5s);

	/* duplicate because we don't want cleared parity in recorded
	 * version */
	memcpy(c->key_material,md5d,MD5_DIGEST_LENGTH);

	des_set_odd_parity((C_Block *)&(md5d[0]));
	des_set_odd_parity((C_Block *)&(md5d[8]));

	if (client)
		{
		des_set_key((C_Block *)&(md5d[0]),ds->read_ks);
		des_set_key((C_Block *)&(md5d[8]),ds->write_ks);
		s->read_key= &(c->key_material[0]);
		s->write_key= &(c->key_material[8]);
		}
	else
		{
		des_set_key((C_Block *)&(md5d[0]),ds->write_ks);
		des_set_key((C_Block *)&(md5d[8]),ds->read_ks);
		s->write_key= &(c->key_material[0]);
		s->read_key= &(c->key_material[8]);
		}
	memcpy(ds->read_iv,s->conn->key_arg,DES_KEY_SZ);
	memcpy(ds->write_iv,s->conn->key_arg,DES_KEY_SZ);
	memset(md5d,0,MD5_DIGEST_LENGTH);
	return(1);
err:
	SSL_errno=SSL_ERRCODE(SSL_F_SSL_ENC_DES_CBC_INIT,SSL_R_OUT_OF_MEMORY);
	return(0);
	}

/* read/writes from s->mac_data using length for encrypt and 
 * decrypt.  It sets the s->padding, s->length and s->pad_data ptr if we
 * are encrypting */
void ssl_enc_des_cbc(s)
SSL *s;
	{
	DES_CBC_STATE *ds;
	unsigned long l;

	ds=(DES_CBC_STATE *)s->crypt_state;

	l=s->length;
	l=(l+7)/8*8;

#ifdef DES_DEBUG
	SSL_TRACE(SSL_ERR,"DES CBC length=%d\n",s->length);
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	if (s->send)
		{
		des_ncbc_encrypt((des_cblock *)s->mac_data,
			(des_cblock *)s->mac_data,(long)l,ds->write_ks,
			(des_cblock *)ds->write_iv,
			DES_ENCRYPT);
		}
	else
		{
		des_ncbc_encrypt((des_cblock *)s->mac_data,
			(des_cblock *)s->mac_data,(long)l,
			ds->read_ks,(des_cblock *)ds->read_iv,DES_DECRYPT);
		}

#ifdef DES_DEBUG
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	}

int ssl_enc_des_ede3_cbc_init(s, client)
SSL *s;
int client;
	{
	MD5_CTX md5s;
	unsigned char md5d0[MD5_DIGEST_LENGTH];
	unsigned char md5d1[MD5_DIGEST_LENGTH];
	unsigned char md5d2[MD5_DIGEST_LENGTH];
	DES_EDE3_CBC_STATE *ds;
	CONN *c;

	if (s->crypt_state == NULL)
		s->crypt_state=(char *)malloc(sizeof(DES_EDE3_CBC_STATE));
	if (s->crypt_state == NULL) goto err;
	ds=(DES_EDE3_CBC_STATE *)s->crypt_state;

	c=s->conn;
	if (c->key_material != NULL) free(c->key_material);
	c->key_material=(unsigned char *)malloc(MD5_DIGEST_LENGTH*3);
	if (c->key_material == NULL) goto err;
	c->key_material_length=MD5_DIGEST_LENGTH*3;

	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,(unsigned char *)"0",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d0,&md5s);

	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,(unsigned char *)"1",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d1,&md5s);

	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,(unsigned char *)"2",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d2,&md5s);

	memcpy(&(s->conn->key_material[0]),md5d0,MD5_DIGEST_LENGTH);
	memcpy(&(s->conn->key_material[MD5_DIGEST_LENGTH]),md5d1,
		MD5_DIGEST_LENGTH);
	memcpy(&(s->conn->key_material[MD5_DIGEST_LENGTH*2]),md5d2,
		MD5_DIGEST_LENGTH);

	des_set_odd_parity((C_Block *)&(md5d0[0]));
	des_set_odd_parity((C_Block *)&(md5d0[8]));
	des_set_odd_parity((C_Block *)&(md5d1[0]));
	des_set_odd_parity((C_Block *)&(md5d1[8]));
	des_set_odd_parity((C_Block *)&(md5d2[0]));
	des_set_odd_parity((C_Block *)&(md5d2[8]));

	if (client)
		{
		des_set_key((C_Block *)&(md5d0[0]),ds->read_ks0);
		des_set_key((C_Block *)&(md5d0[8]),ds->read_ks1);
		des_set_key((C_Block *)&(md5d1[0]),ds->read_ks2);
		des_set_key((C_Block *)&(md5d1[8]),ds->write_ks0);
		des_set_key((C_Block *)&(md5d2[0]),ds->write_ks1);
		des_set_key((C_Block *)&(md5d2[8]),ds->write_ks2);
		s->read_key= &(s->conn->key_material[0]);
		s->write_key= &(s->conn->key_material[24]);
		}
	else
		{
		des_set_key((C_Block *)&(md5d0[0]),ds->write_ks0);
		des_set_key((C_Block *)&(md5d0[8]),ds->write_ks1);
		des_set_key((C_Block *)&(md5d1[0]),ds->write_ks2);
		des_set_key((C_Block *)&(md5d1[8]),ds->read_ks0);
		des_set_key((C_Block *)&(md5d2[0]),ds->read_ks1);
		des_set_key((C_Block *)&(md5d2[8]),ds->read_ks2);
		s->write_key= &(s->conn->key_material[0]);
		s->read_key= &(s->conn->key_material[24]);
		}
	memcpy(ds->read_iv,s->conn->key_arg,DES_KEY_SZ);
	memcpy(ds->write_iv,s->conn->key_arg,DES_KEY_SZ);

	memset(md5d0,0,MD5_DIGEST_LENGTH);
	memset(md5d1,0,MD5_DIGEST_LENGTH);
	memset(md5d2,0,MD5_DIGEST_LENGTH);
	return(1);
err:
	SSL_errno=SSL_ERRCODE(SSL_F_SSL_ENC_DES_EDE3_CBC_INIT,
		SSL_R_OUT_OF_MEMORY);
	return(0);
	}

/* read/writes from s->mac_data using length for encrypt and 
 * decrypt.  It sets the s->padding, s->length and s->pad_data ptr if we
 * are encrypting */
void ssl_enc_des_ede3_cbc(s)
SSL *s;
	{
	DES_EDE3_CBC_STATE *ds;
	unsigned long l;

	ds=(DES_EDE3_CBC_STATE *)s->crypt_state;

	l=s->length;
	l=(l+7)/8*8;

#ifdef DES_DEBUG
	SSL_TRACE(SSL_ERR,"DES EDE3 length=%d\n",s->length);
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	if (s->send)
		{
		des_ede3_cbc_encrypt((des_cblock *)s->mac_data,
			(des_cblock *)s->mac_data,(long)l,
			ds->write_ks0,
			ds->write_ks1,
			ds->write_ks2,
			(des_cblock *)ds->write_iv,
			DES_ENCRYPT);
		}
	else
		{
		des_ede3_cbc_encrypt((des_cblock *)s->mac_data,
			(des_cblock *)s->mac_data,(long)l,
			ds->read_ks0,
			ds->read_ks1,
			ds->read_ks2,
			(des_cblock *)ds->read_iv,
			DES_DECRYPT);
		}

#ifdef DES_DEBUG
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	}

int ssl_enc_des_cfb_init(s, client)
SSL *s;
int client;
	{
	MD5_CTX md5s;
	unsigned char md5d[MD5_DIGEST_LENGTH];
	DES_CFB_STATE *ds;
	CONN *c;

	if (s->crypt_state == NULL)
		s->crypt_state=(char *)malloc(sizeof(DES_CFB_STATE));
	if (s->crypt_state == NULL) goto err;
	ds=(DES_CFB_STATE *)s->crypt_state;

	c=s->conn;
	if (c->key_material != NULL) free(c->key_material);
	c->key_material=(unsigned char *)malloc(MD5_DIGEST_LENGTH);
	if (c->key_material == NULL) goto err;
	c->key_material_length=MD5_DIGEST_LENGTH;

	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d,&md5s);

	/* duplicate because we don't want cleared parity in recorded
	 * version */
	memcpy(c->key_material,md5d,MD5_DIGEST_LENGTH);

	des_set_odd_parity((C_Block *)&(md5d[0]));
	des_set_odd_parity((C_Block *)&(md5d[8]));

	if (client)
		{
		des_set_key((C_Block *)&(md5d[0]),ds->read_ks);
		des_set_key((C_Block *)&(md5d[8]),ds->write_ks);
		s->read_key= &(c->key_material[0]);
		s->write_key= &(c->key_material[8]);
		}
	else
		{
		des_set_key((C_Block *)&(md5d[0]),ds->write_ks);
		des_set_key((C_Block *)&(md5d[8]),ds->read_ks);
		s->write_key= &(c->key_material[0]);
		s->read_key= &(c->key_material[8]);
		}
	ds->readn=0;
	ds->writen=0;
	memcpy(ds->read_iv,s->conn->key_arg,DES_KEY_SZ);
	memcpy(ds->write_iv,s->conn->key_arg,DES_KEY_SZ);
	memset(md5d,0,MD5_DIGEST_LENGTH);
	return(1);
err:
	SSL_errno=SSL_ERRCODE(SSL_F_SSL_ENC_DES_EDE3_CBC_INIT,
		SSL_R_OUT_OF_MEMORY);
	return(0);
	}

/* read/writes from s->mac_data using length for encrypt and 
 * decrypt.  It sets the s->padding, s->length and s->pad_data ptr if we
 * are encrypting */
void ssl_enc_des_cfb(s)
SSL *s;
	{
	DES_CFB_STATE *ds;
	unsigned long l;

	ds=(DES_CFB_STATE *)s->crypt_state;

	l=s->length;

#ifdef DES_DEBUG
	SSL_TRACE(SSL_ERR,"DES CFB length=%d\nn=%d riv=",s->length,
		ds->readn);
	ssl_print_bytes(SSL_ERR,8,ds->read_iv);
	SSL_TRACE(SSL_ERR,"\nn=%d wiv=",ds->writen);
	ssl_print_bytes(SSL_ERR,8,ds->write_iv);
	SSL_TRACE(SSL_ERR,"\n");
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	if (s->send)
		{
		des_cfb64_encrypt((unsigned char *)s->mac_data,
			(unsigned char *)s->mac_data,(long)l,ds->write_ks,
			(des_cblock *)ds->write_iv,&ds->writen,
			DES_ENCRYPT);
		}
	else
		{
		des_cfb64_encrypt((unsigned char *)s->mac_data,
			(unsigned char *)s->mac_data,(long)l,ds->read_ks,
			(des_cblock *)ds->read_iv,&ds->readn,
			DES_DECRYPT);
		}

#ifdef DES_DEBUG
	ssl_print_bytes(SSL_ERR,l,s->mac_data);
	SSL_TRACE(SSL_ERR,"\n");
#endif
	}
