/* socket.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/time.h> /* Needed under linux for FD_XXX */
#include <netinet/in.h>
#include <errno.h>
#include "net.h"
#include "ssl.h"
#include "ssl_apps.h"

extern int errno;

int init_client(sock, server, port)
int *sock;
char *server;
int port;
	{
	struct sockaddr_in them;
	struct hostent *host;
	struct protoent *prot;
	u_long ip_them;
	int s,i;

	host=gethostbyname(server);
	if (host == NULL)
		{
		int a,b,c,d;

		if (sscanf(server,"%d.%d.%d.%d",&a,&b,&c,&d) == 4)
			ip_them=(a<<24)|(b<<16)|(c<<8)|d;
		else
			{
			fprintf(stderr,"unable to get %s's ip address\n",
				server);
			return(0);
			}
		}
	else
		memcpy(&ip_them,host->h_addr_list[0],sizeof(ip_them));
	memset((char *)&them,0,sizeof(them));
	them.sin_family=AF_INET;
	them.sin_port=htons(port);
	them.sin_addr.s_addr=ip_them;

	prot=getprotobyname("tcp");
	if (prot == NULL)
		{
		fprintf(stderr,"unable to find tcp protocol number");
		return(0);
		}
	s=socket(AF_INET,SOCK_STREAM,prot->p_proto);
	if (s == -1) { fprintf(stderr,"socket:%m"); return(0); }

/*	ling.l_onoff=1;
	ling.l_linger=0;
	i=setsockopt(s,SOL_SOCKET,SO_LINGER,(char *)&ling,sizeof(ling));
	if (i < 0) { fprintf(stderr,"linger:%m"); exit(0); } /**/
	i=0;
	i=setsockopt(s,SOL_SOCKET,SO_KEEPALIVE,(char *)&i,sizeof(i));
	if (i < 0) { fprintf(stderr,"keepalive:%m"); exit(0); }

	if (connect(s,(struct sockaddr *)&them,sizeof(them)) == -1)
		{
		close(s);
		perror("connect");
		return(0);
		}
	*sock=s;
	return(1);
	}

void do_server(port, ret, cb)
int port;
int *ret;
int (*cb)();
	{
	int sock;
	char *name;
	int accept_socket;

	if (!init_server(&accept_socket,port)) exit(1);

	if (ret != NULL)
		{
		*ret=accept_socket;
		return;
		}
	for (;;)
		{
		if (do_accept(accept_socket,&sock,&name) == 0)
			exit(1);
		(*cb)(name,sock);
		free(name);
		close(sock);
		}
	}

int init_server(sock, port)
int *sock;
int port;
	{
	struct sockaddr_in server;
	int s,i;
	struct linger ling;

	server.sin_family=AF_INET;
	server.sin_port=htons(port);
	server.sin_addr.s_addr=INADDR_ANY;

	s=socket(AF_INET,SOCK_STREAM,0);
	if (s == -1) return(0);
	if (bind(s,(struct sockaddr *)&server,sizeof(server)) == -1)
		{
		perror("bind");
		return(0);
		}
	if (listen(s,5) == -1) return(0);
	ling.l_onoff=1;
	ling.l_linger=0;
	i=setsockopt(s,SOL_SOCKET,SO_LINGER,(char *)&ling,sizeof(ling));
	if (i < 0) { perror("linger"); exit(0); }

	i=0;
	*sock=s;
	return(1);
	}

int do_accept(acc_sock, sock, host)
int acc_sock;
int *sock;
char **host;
	{
	int ret,i;
	struct hostent *h1,*h2;
	static struct sockaddr_in from;
	int len;
	struct linger ling;

redoit:
	memset((char *)&from,0,sizeof(from));
	len=sizeof(from);
	ret=accept(acc_sock,(struct sockaddr *)&from,&len);
	if (ret == -1)
		{
		if (errno == EINTR)
			{
			/*check_timeout();/**/
			goto redoit;
			}
		perror("accept");
		return(0);
		}
	
	ling.l_onoff=1;
	ling.l_linger=0;
	i=setsockopt(ret,SOL_SOCKET,SO_LINGER,(char *)&ling,sizeof(ling));
	if (i < 0) { perror("linger"); exit(0); }
	i=0;
	i=setsockopt(ret,SOL_SOCKET,SO_KEEPALIVE,(char *)&i,sizeof(i));
	if (i < 0) { perror("keepalive"); exit(0); }

	h1=gethostbyaddr((char *)&from.sin_addr.s_addr,
		sizeof(from.sin_addr.s_addr),AF_INET);
	if (h1 == NULL)
		{
		fprintf(stderr,"bad gethostbyaddr\n");
		return(0);
		}
	if ((*host=(char *)malloc(strlen(h1->h_name)+1)) == NULL)
		{
		perror("malloc");
		return(0);
		}
	strcpy(*host,h1->h_name);

	h2=gethostbyname(h1->h_name);
	i=0;
	if (h2->h_addrtype != AF_INET)
		{
		fprintf(stderr,"gethostbyname addr is not AF_INET\n");
		return(0);
		}
	*sock=ret;
	return(1);
	}

int spawn(argc, argv, in, out)
int argc;
char **argv;
int *in;
int *out;
	{
#define CHILD_READ	p1[0]
#define CHILD_WRITE	p2[1]
#define PARENT_READ	p2[0]
#define PARENT_WRITE	p1[1]
	int p1[2],p2[2];

	if ((pipe(p1) < 0) || (pipe(p2) < 0)) return(-1);

	if (fork() == 0)
		{ /* child */
		if (dup2(CHILD_WRITE,fileno(stdout)) < 0)
			perror("dup2");
		if (dup2(CHILD_WRITE,fileno(stderr)) < 0)
			perror("dup2");
		if (dup2(CHILD_READ,fileno(stdin)) < 0)
			perror("dup2");
		close(CHILD_READ); 
		close(CHILD_WRITE);

		close(PARENT_READ);
		close(PARENT_WRITE);
		execvp(argv[0],argv);
		perror("child");
		exit(1);
		}

	/* parent */
	*in= PARENT_READ;
	*out=PARENT_WRITE;
	close(CHILD_READ);
	close(CHILD_WRITE);
	return(1);
	}
