/* callback.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <stdlib.h>
#include "X509.h"
#include "ssl.h"

extern int verify_depth;
extern int verify_error;

/* should be X509 * but we can just have them as char *. */
int verify_callback(ok, xs, xi, depth, error)
int ok;
X509 *xs;
X509 *xi;
int depth;
int error;
	{
	char *s;

	s=(char *)X509_oneline_X509_NAME(X509_get_subject_name(xs));
	if (s == NULL)
		{
		fprintf(stderr,"error:%s\n",X509_error_string(X509_errno));
		return(0);
		}
	fprintf(stderr,"depth=%d %s\n",depth,s);
	free(s);
	if (error == VERIFY_ERR_UNABLE_TO_GET_ISSUER)
		{
		s=(char *)X509_oneline_X509_NAME(X509_get_issuer_name(xs));
		if (s == NULL)
			{
			fprintf(stderr,"verify error:%s\n",
				X509_error_string(X509_errno));
			return(0);
			}
		fprintf(stderr,"issuer= %s\n",s);
		free(s);
		}
	if (!ok)
		{
		fprintf(stderr,"verify error:num=%d:%s\n",error,
			X509_verify_error_string(error));
		if (verify_depth <= depth)
			{
			ok=1;
			verify_error=VERIFY_OK;
			}
		else
			{
			ok=0;
			verify_error=error;
			}
		}
	fprintf(stderr,"verify return:%d\n",ok);
	return(ok);
	}

void set_cert_stuff(con, cert_file, key_file)
SSL *con;
char *cert_file;
char *key_file;
	{
	if (cert_file != NULL)
		{
		if (SSL_use_certificate_file(con,cert_file,
			X509_FILETYPE_PEM) <= 0)
			{
			fprintf(stderr,"unable to set certificate file\n");
			fprintf(stderr,"%s\n",SSL_error_string(SSL_errno));
			exit(1);
			}
		if (key_file == NULL) key_file=cert_file;
		if (SSL_use_RSAPrivateKey_file(con,key_file,
			X509_FILETYPE_PEM) <= 0)
			{
			fprintf(stderr,"unable to set public key file\n");
			fprintf(stderr,"%s\n",SSL_error_string(SSL_errno));
			exit(1);
			}
		}
	}

