/* rsa.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <time.h>
#include "der.h"
#include "bn.h"
#include "X509.h"
#include "PEM.h"

#define FORMAT_UNDEF	0
#define FORMAT_DER	1
#define FORMAT_TEXT	2
#define FORMAT_PEM	3

/* -inform arg	- input format - default PEM (one of DER, TXT or PEM)
 * -outform arg - output format - default PEM
 * -in arg	- input file - default stdin
 * -out arg	- output file - default stdout
 * -enc		- encrypt output if PEM format
 */

#ifdef PROTO
static int str2fmt (char *s);
#else
static int str2fmt ();
#endif

main(argc, argv)
int argc;
char **argv;
	{
	RSA *rsa;
	int i,badops=0,enc=0;
	FILE *in,*out;
	int informat,outformat;
	char *infile,*outfile;

	infile=NULL;
	outfile=NULL;
	informat=FORMAT_PEM;
	outformat=FORMAT_PEM;

	argc--;
	argv++;
	while (argc >= 1)
		{
		if 	(strcmp(*argv,"-inform") == 0)
			{
			if (argc-- < 1) goto bad;
			informat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-outform") == 0)
			{
			if (argc-- < 1) goto bad;
			outformat=str2fmt(*(++argv));
			}
		else if (strcmp(*argv,"-in") == 0)
			{
			if (argc-- < 1) goto bad;
			infile= *(++argv);
			}
		else if (strcmp(*argv,"-out") == 0)
			{
			if (argc-- < 1) goto bad;
			outfile= *(++argv);
			}
		else if (strcmp(*argv,"-enc") == 0)
			enc=1;
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badops=1;
			break;
			}
		argc--;
		argv++;
		}

	if (badops)
		{
bad:
		fprintf(stderr,"%s [options] <infile >outfile\n",argv[0]);
		fprintf(stderr,"where options are\n");
		fprintf(stderr," -inform arg   input format - one of DER TXT PEM\n");
		fprintf(stderr," -outform arg  output format - one of DER TXT PEM\n");
		fprintf(stderr," -in arg       inout file\n");
		fprintf(stderr," -out arg      output file\n");
		exit(1);
		}

	if (infile == NULL)
		in=stdin;
	else
		{
		in=fopen(infile,"r");
		if (in == NULL)
			{
			perror(infile);
			exit(1);
			}
		}

	fprintf(stderr,"read RSA private key\n");
	rsa=RSA_new();
	if	(informat == FORMAT_DER)
		i=D2i_RSAPrivateKey_fp(in,rsa);
	else if (informat == FORMAT_TEXT)
		i=f2i_RSAPrivateKey(in,rsa);
	else if (informat == FORMAT_PEM)
		i=PEM_read_RSA(in,rsa);
	else
		{
		fprintf(stderr,"bad input format specified for key\n");
		exit(1);
		}
	if (!i)
		{
		fprintf(stderr,"unable to load Private Key\n");
		exit(1);
		}

	if (outfile == NULL)
		out=stdout;
	else
		{
		out=fopen(outfile,"w");
		if (out == NULL)
			{
			perror(outfile);
			exit(1);
			}
		}

	fprintf(stderr,"writing RSA private key\n");
	if 	(outformat == FORMAT_DER)
		i=i2D_RSAPrivateKey_fp(out,rsa);
	else if (outformat == FORMAT_TEXT)
		i=i2f_RSAPrivateKey(out,rsa);
	else if (outformat == FORMAT_PEM)
		i=PEM_write_RSA(out,rsa,enc,0,NULL);
	else	{
		fprintf(stderr,"bad output format specified for outfile\n");
		exit(1);
		}
	if (!i)
		{
		fprintf(stderr,"unable to write private key\n");
		exit(1);
		}
	fclose(out);
	exit(0);
	return(0);
	}

static int str2fmt(s)
char *s;
	{
	if 	((*s == 'D') || (*s == 'd'))
		return(FORMAT_DER);
	else if ((*s == 'T') || (*s == 't'))
		return(FORMAT_TEXT);
	else if ((*s == 'P') || (*s == 'p'))
		return(FORMAT_PEM);
	else
		return(FORMAT_UNDEF);
	}
