/* genrsa.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "X509.h"
#include "PEM.h"

#define DEFBITS	512

#ifdef PROTO
static void cb(int p, int n);
#else
static void cb();
#endif

main(argc, argv)
int argc;
char **argv;
	{
	RSA *rsa;
	int num=DEFBITS;
	int i,enc=0;

	for (i=1; i<argc; i++)
		{
		if (strcmp(argv[i],"-enc") == 0)
			enc=1;
		else
			break;
		}
	if ((i < argc) && (sscanf(argv[i],"%d",&num) == 0))
		{
		num=DEFBITS;
		fprintf(stderr,"usage: genrsa [-enc] [numbits]\n");
		exit(1);
		}
	fprintf(stderr,"Generating RSA private key, %d bit long modulus\n",
		num);
	RSA_set_generate_prime_callback(cb);
	rsa=RSA_generate_key(num,1);
	if (rsa == NULL)
		{
		fprintf(stderr,"RSA_generate_key:%s\n",
			RSA_error_string(RSA_errno));
		exit(1);
		}
	if (!PEM_write_RSA(stdout,rsa,enc,0,NULL))
		{
		fprintf(stderr,"PEM_write_RSA:%s\n",
			PEM_error_string(PEM_errno));
		exit(1);
		}
	exit(0);
	return(0); /* shut lint up */
	}

static void cb(p, n)
int p;
int n;
	{
	char *str;

	if (p == 0) str=".";
	if (p == 1) str="+";
	if (p == 2) str="\n";
	fprintf(stderr,str);
	fflush(stderr);
	}
