/* errstr.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "der.h"
#include "X509.h"
#include "PEM.h"

/* NOTE: these error strings are a direct mapping of the #define to a
 * string.  This will change as I get time to put a more meaningfull
 * error messages in :-)
 */

char *PEM_error_string(n)
int n;
	{
	static char buf[100];

	switch (n)
		{
	case PEM_ERR_DER:  return(DER_error_string(DER_errno));
	case PEM_ERR_RSA:  return(RSA_error_string(RSA_errno));
	case PEM_ERR_X509: return(X509_error_string(X509_errno));

	case PEM_ERR_MALLOC_FAILURE:
		return("PEM_ERR_MALLOC_FAILURE");
	case PEM_ERR_NO_START_LINE:
		return("PEM_ERR_NO_START_LINE");
	case PEM_ERR_BAD_END_LINE:
		return("PEM_ERR_BAD_END_LINE");
	case PEM_ERR_DECODEING_ERROR:
		return("PEM_ERR_DECODEING_ERROR");
	case PEM_ERR_READ_KEY:
		return("PEM_ERR_READ_KEY");
	case PEM_ERR_NOT_PROC_TYPE:
		return("PEM_ERR_NOT_PROC_TYPE");
	case PEM_ERR_NOT_ENCRYPTED:
		return("PEM_ERR_NOT_ENCRYPTED");
	case PEM_ERR_SHORT_HEADER:
		return("PEM_ERR_SHORT_HEADER");
	case PEM_ERR_NOT_DEK_INFO:
		return("PEM_ERR_NOT_DEK_INFO");
	case PEM_ERR_BAD_CBC_IV_CHARS:
		return("PEM_ERR_BAD_CBC_IV_CHARS");
	case PEM_ERR_BAD_READ_PW_STRING:
		return("PEM_ERR_BAD_READ_PW_STRING");
	case PEM_ERR_BAD_CBC_DECRYPT:
		return("PEM_ERR_BAD_CBC_DECRYPT");
	case PEM_ERR_UNSUPPORTED_ENCRYPTION:
		return("PEM_ERR_UNSUPPORTED_ENCRYPTION");
	case PEM_ERR_BASE64_LINE_TOO_LONG:
		return("PEM_ERR_BASE64_LINE_TOO_LONG");
	case PEM_ERR_BASE64_BAD_INPUT_CHAR:
		return("PEM_ERR_BASE64_BAD_INPUT_CHAR");
	default:
		sprintf(buf,"PEM error number %d",n);
		return(buf);
		}
	}

char *RSA_error_string(n)
int n;
	{
	static char buf[100];

	switch (n)
		{
	case RSA_ERR_OUT_OF_MEM:
		return("RSA_ERR_OUT_OF_MEM");
	case RSA_ERR_DIV_BY_ZERO:
		return("RSA_ERR_DIV_BY_ZERO");
	case RSA_ERR_NULL_ARG_TO_BN_EXPAND:
		return("RSA_ERR_NULL_ARG_TO_BN_EXPAND");
	case RSA_ERR_INVERSE_MODN_NO_SOLUTION:
		return("RSA_ERR_INVERSE_MODN_NO_SOLUTION");
	case RSA_ERR_BAD_BN_MODMUL_RECIP:
		return("RSA_ERR_BAD_BN_MODMUL_RECIP");
	case RSA_ERR_ENC_DATA_TO_BIG:
		return("RSA_ERR_ENC_DATA_TO_BIG");
	case RSA_ERR_DEC_DATA_NOT_EQ_TO_MOD_LENGTH:
		return("RSA_ERR_DEC_DATA_NOT_EQ_TO_MOD_LENGTH");
	case RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_02:
		return("RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_02");
	case RSA_ERR_DEC_NULL_BEFORE_BLOCK_MISSING:
		return("RSA_ERR_DEC_NULL_BEFORE_BLOCK_MISSING");
	case RSA_ERR_DEC_BAD_PAD_BYTE_COUNT:
		return("RSA_ERR_DEC_BAD_PAD_BYTE_COUNT");
	case RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_01:
		return("RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_01");
	case RSA_ERR_DEC_BAD_FF_HEADER:
		return("RSA_ERR_DEC_BAD_FF_HEADER");
	default:
		sprintf(buf,"RSA error number %d",n);
		return(buf);
		}
	}


char *X509_error_string(n)
int n;
	{
	static char buf[100];

	switch (n)
		{
	case X509_ERR_DER: return(DER_error_string(DER_errno));
	case X509_ERR_PEM: return(PEM_error_string(PEM_errno));
	case X509_ERR_RSA: return(RSA_error_string(RSA_errno));

	case X509_ERR_BAD_CERT_DECODE:
		return("X509_ERR_BAD_CERT_DECODE");
	case X509_ERR_NO_ISSUER_CERT:
		return("X509_ERR_NO_ISSUER_CERT");
	case X509_ERR_BAD_CERT_INIT:
		return("X509_ERR_BAD_CERT_INIT");
	case X509_ERR_OUT_OF_MEM:
		return("X509_ERR_OUT_OF_MEM");
	case X509_ERR_CERT_ALREADY_IN_HASH_TABLE:
		return("X509_ERR_CERT_ALREADY_IN_HASH_TABLE");
	case X509_ERR_CERT_FILE_OPEN_ERROR:
		return("X509_ERR_CERT_FILE_OPEN_ERROR");
	case X509_ERR_HIT_IN_OBJECT_STORAGE_VERY_BAD:
		return("X509_ERR_HIT_IN_OBJECT_STORAGE_VERY_BAD");
	case X509_ERR_HIT_IN_NID_STORAGE_VERY_BAD:
		return("X509_ERR_HIT_IN_NID_STORAGE_VERY_BAD");
	case X509_ERR_HIT_IN_SN_STORAGE_VERY_BAD:
		return("X509_ERR_HIT_IN_SN_STORAGE_VERY_BAD");
	case X509_ERR_HIT_IN_LN_STORAGE_VERY_BAD:
		return("X509_ERR_HIT_IN_LN_STORAGE_VERY_BAD");
	case X509_ERR_BAD_X509_FILETYPE:
		return("X509_ERR_BAD_X509_FILETYPE");
	default:
		sprintf(buf,"X509 error number %d",n);
		return(buf);
		}
	}

char *DER_error_string(n)
int n;
	{
	static char buf[100];

	switch (n)
		{
	case DER_ERR_RSA: return(RSA_error_string(RSA_errno));

	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_ALGOR:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_ALGOR");
	case DER_ERR_EXPECTING_A_NULL_IN_D2I_X509_ALGOR:
		return("DER_ERR_EXPECTING_A_NULL_IN_D2I_X509_ALGOR");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_NAME:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_NAME");
	case DER_ERR_EXPECTING_A_SET_IN_D2I_X509_NAME:
		return("DER_ERR_EXPECTING_A_SET_IN_D2I_X509_NAME");
	case DER_ERR_EXISTING_OBJECTS_FOUND_IN_D2I_X509_NAME:
		return("DER_ERR_EXISTING_OBJECTS_FOUND_IN_D2I_X509_NAME");
	case DER_ERR_OUT_OF_MEM:
		return("DER_ERR_OUT_OF_MEM");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_VAL:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_VAL");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_PUBKEY:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_PUBKEY");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_SIG:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_SIG");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_CINF:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_CINF");
	case DER_ERR_UNABLE_TO_OPEN_FILE:
		return("DER_ERR_UNABLE_TO_OPEN_FILE");
	case DER_ERR_FILE_TOO_SMALL_IN_D2I_X509_FP:
		return("DER_ERR_FILE_TOO_SMALL_IN_D2I_X509_FP");
	case DER_ERR_NOT_ENOUGH_DATA_PASSED_IN_D2I_X509:
		return("DER_ERR_NOT_ENOUGH_DATA_PASSED_IN_D2I_X509");
	case DER_ERR_FILE_TOO_SMALL_IN_D2I_RSAPRIVATEKEY_FP:
		return("DER_ERR_FILE_TOO_SMALL_IN_D2I_RSAPRIVATEKEY_FP");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_RSAPRIVATEKEY:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_RSAPRIVATEKEY");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_RSAPUBLICKEY:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_RSAPUBLICKEY");
	case DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509:
		return("DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509");

	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_ALGOR:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_ALGOR");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_ALGOR:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_ALGOR");
	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_NAME:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_NAME");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_NAME:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_NAME");
	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_VAL:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_VAL");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_VAL:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_VAL");
	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_PUBKEY:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_PUBKEY");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_PUBKEY:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_PUBKEY");
	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509");
	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_SIG:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_SIG");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_SIG:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_SIG");

	case DER_ERR_SHORT_LINE_IN_F2I_PRINTABLESTRING:
		return("DER_ERR_SHORT_LINE_IN_F2I_PRINTABLESTRING");
	case DER_ERR_BAD_SOL_CHARACTER:
		return("DER_ERR_BAD_SOL_CHARACTER");
	case DER_ERR_BAD_EOL_CHARACTER:
		return("DER_ERR_BAD_EOL_CHARACTER");
	case DER_ERR_ODD_NUMBER_OF_CHARS_ON_LINE:
		return("DER_ERR_ODD_NUMBER_OF_CHARS_ON_LINE");
	case DER_ERR_NON_HEX_CHARACTERS:
		return("DER_ERR_NON_HEX_CHARACTERS");
	case DER_ERR_SHORT_LINE_IN_F2I_DER_OBJECT:
		return("DER_ERR_SHORT_LINE_IN_F2I_DER_OBJECT");

	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPRIVATEKEY:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPRIVATEKEY");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPRIVATEKEY:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPRIVATEKEY");
	case DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPUBLICKEY:
		return("DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPUBLICKEY");
	case DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPUBLICKEY:
		return("DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPUBLICKEY");

	case DER_ERR_X509_TO_LARGE_IN_I2D_X509_FP:
		return("DER_ERR_X509_TO_LARGE_IN_I2D_X509_FP");
	case DER_ERR_RSA_KEY_TOO_SMALL_IN_I2D_RSAPRIVATEKEY_FP:
		return("DER_ERR_RSA_KEY_TOO_SMALL_IN_I2D_RSAPRIVATEKEY_FP");

	case DER_ERR_EXPECTING_AN_INTEGER_IN_D2I_INTEGER:
		return("DER_ERR_EXPECTING_AN_INTEGER_IN_D2I_INTEGER");
	case DER_ERR_EXPECTING_AN_OBJECT_IDENTIFIER_IN_D2I_DER_OBJECT:
		return("DER_ERR_EXPECTING_AN_OBJECT_IDENTIFIER_IN_D2I_DER_OBJECT");
	case DER_ERR_EXPECTING_A_PRINTABLESTRING_IN_D2I_PRINTABLESTRING:
		return("DER_ERR_EXPECTING_A_PRINTABLESTRING_IN_D2I_PRINTABLESTRING");
	case DER_ERR_EXPECTING_A_DER_BIT_STRING_IN_D2i_DER_BIT_STRING:
		return("DER_ERR_EXPECTING_A_DER_BIT_STRING_IN_D2i_DER_BIT_STRING");
	case DER_ERR_EXPECTING_AN_OCTET_STRING_IN_D2i_OCTET_STRING:
		return("DER_ERR_EXPECTING_AN_OCTET_STRING_IN_D2i_OCTET_STRING");
	case DER_ERR_EXPECTING_A_DER_UTCTIME_IN_D2I_UTCTIME:
		return("DER_ERR_EXPECTING_A_DER_UTCTIME_IN_D2I_UTCTIME");
	default:
		sprintf(buf,"DER error number %d",n);
		return(buf);
		}
	}
