/* der.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_DER_H
#define HEADER_DER_H

#define DER_UNIVERSAL		0x00
#define	DER_APPLICATION		0x40
#define DER_CONTEXT_SPECIFIC	0x80
#define DER_PRIVATE		0xb0

#define DER_CONSTRUCTED		0x20
#define DER_PRIMATIVE_TAG	0x1f

#define DER_EOC				0
#define DER_INTEGER			2
#define DER_BIT_STRING_IDENTIFIER	3
#define DER_OCTET_STRING		4
#define DER_NULL			5
#define DER_OBJECT_IDENTIFIER		6
#define DER_SEQUENCE			16
#define DER_SET				17
#define DER_PRINTABLESTRING		19
#define DER_T61STRING			20
#define DER_IA5STRING			22
#define DER_UTCTIME			23

typedef struct object_st
	{
	int num;
	unsigned long *values;
	int nid;
	char *sn,*ln;
	} DER_OBJECT;

typedef struct bit_string_st
	{
	int length;
	unsigned char *data;
	} DER_BIT_STRING;

/*#define DER_DEBUG /**/
/*#define VRFY_DEBUG /**/

#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_ALGOR		1
#define DER_ERR_EXPECTING_A_NULL_IN_D2I_X509_ALGOR		2
#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_NAME		3
#define DER_ERR_EXPECTING_A_SET_IN_D2I_X509_NAME		4
#define DER_ERR_EXISTING_OBJECTS_FOUND_IN_D2I_X509_NAME		5
#define DER_ERR_OUT_OF_MEM					6
#define	DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_VAL		7
#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_PUBKEY		8
#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_SIG		9
#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509_CINF		10
#define DER_ERR_UNABLE_TO_OPEN_FILE				11
#define DER_ERR_FILE_TOO_SMALL_IN_D2I_X509_FP			12
#define DER_ERR_NOT_ENOUGH_DATA_PASSED_IN_D2I_X509		13
#define DER_ERR_FILE_TOO_SMALL_IN_D2I_RSAPRIVATEKEY_FP		14
#define DER_ERR_RSA						15
#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_RSAPRIVATEKEY	16
#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_RSAPUBLICKEY	17
#define DER_ERR_EXPECTING_A_SEQUENCE_IN_D2I_X509		18

#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_ALGOR		20
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_ALGOR		21
#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_NAME		22
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_NAME		23
#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_VAL		24
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_VAL		25
#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_PUBKEY	26
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_PUBKEY		27
#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509		30
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509			31
#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_X509_SIG		32
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_X509_SIG		33

#define DER_ERR_SHORT_LINE_IN_F2I_PRINTABLESTRING		40
#define DER_ERR_BAD_SOL_CHARACTER				41
#define DER_ERR_BAD_EOL_CHARACTER				42
#define DER_ERR_ODD_NUMBER_OF_CHARS_ON_LINE			43
#define DER_ERR_NON_HEX_CHARACTERS				44
#define DER_ERR_SHORT_LINE_IN_F2I_DER_OBJECT			45

#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPRIVATEKEY	50
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPRIVATEKEY	51
#define DER_ERR_EXPECTING_BEGIN_TOKEN_IN_F2I_RSAPUBLICKEY	52
#define DER_ERR_EXPECTING_END_TOKEN_IN_F2I_RSAPUBLICKEY		53

#define DER_ERR_X509_TO_LARGE_IN_I2D_X509_FP			60
#define DER_ERR_RSA_KEY_TOO_SMALL_IN_I2D_RSAPRIVATEKEY_FP	61

#define	DER_ERR_EXPECTING_AN_INTEGER_IN_D2I_INTEGER		70
#define	DER_ERR_EXPECTING_AN_OBJECT_IDENTIFIER_IN_D2I_DER_OBJECT 71
#define	DER_ERR_EXPECTING_A_PRINTABLESTRING_IN_D2I_PRINTABLESTRING 72
#define	DER_ERR_EXPECTING_A_DER_BIT_STRING_IN_D2i_DER_BIT_STRING 73
#define	DER_ERR_EXPECTING_AN_OCTET_STRING_IN_D2i_OCTET_STRING	74
#define	DER_ERR_EXPECTING_A_DER_UTCTIME_IN_D2I_UTCTIME		75

extern int DER_errno;

#ifdef PROTO
char *		DER_error_string(int n);
DER_BIT_STRING *DER_BIT_STRING_new(void);
DER_OBJECT *    DER_OBJECT_new(void);
void 		DER_BIT_STRING_free (DER_BIT_STRING *a);
int		DER_OBJECT_eq (DER_OBJECT *a, DER_OBJECT *b);
void		DER_OBJECT_free (DER_OBJECT *a);
int		DER_get_object (unsigned char **pp, unsigned long *plength, int * ptag, int *pclass);
void		DER_put_object(unsigned char **pp, int constructed, int length, int tag, int class);
int		DER_object_size (int constructed, int length, int tag);
void		DER_parse (FILE *fp, unsigned char *pp, int len);
#else
char *		DER_error_string();
DER_BIT_STRING *DER_BIT_STRING_new();
DER_OBJECT *    DER_OBJECT_new();
void 		DER_BIT_STRING_free ();
int		DER_OBJECT_eq ();
void		DER_OBJECT_free ();
int		DER_get_object ();
void		DER_put_object();
int		DER_object_size ();
void		DER_parse ();
#endif

#endif
