/* bn_regs.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "bn.h"
#include "X509.h"

#define REG_INC	8

static int num_regs=0;
static int bn_tos=0;
static BIGNUM **regs=NULL;

void bn_clean_up()
	{
	int i,j;
	BN_ULONG *d;

	for (i=bn_tos; i<num_regs; i++)
		{
		d=regs[i]->d;
		for (j=regs[i]->max-1; j>=0; j--)
			d[j]=0;
		bn_free(regs[i]);
		regs[i]=NULL;
		}
	num_regs=bn_tos;
	}

int bn_get_tos()
	{
	return(bn_tos);
	}

void bn_set_tos(a)
int a;
	{
	bn_tos=a;
	}

BIGNUM *bn_get_reg()
	{
	int i;

	if (regs == NULL)
		{
		num_regs=0;
		regs=(BIGNUM **)malloc(sizeof(BIGNUM *)*1);
		if (regs == NULL) goto err;
		bn_tos=0;
		}
	if (bn_tos >= num_regs)
		{
		i=num_regs;
		num_regs+=REG_INC;
		regs=(BIGNUM **)realloc(regs,sizeof(BIGNUM *)*num_regs);
		if (regs == NULL) goto err;
		for (; i<num_regs; i++)
			{
			regs[i]=bn_new();
			if (regs[i] == NULL) goto err;
			}
		}
	return(regs[bn_tos++]);
err:
	RSA_errno=RSA_ERR_OUT_OF_MEM;
	return(NULL);
	}

