/* X509_obj.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "lhash.h"
#include "der.h"
#include "X509.h"
#include "X509_obj.h"
#include "Buffer.h"

/* Perhaps I should have objects as strings?  bit late now :-( */

static struct obj_st 
	{
	char *sn,*ln;
	int nid;
	int nums[8];
	} objs[]={
	{NULL,LN_rsadsi,NID_rsadsi,OBJ_rsadsi,0},
	{NULL,LN_pkcs,NID_pkcs,OBJ_pkcs,0},
	{NULL,LN_md2,NID_md2,OBJ_md2,0},
	{NULL,LN_md5,NID_md5,OBJ_md5,0},
	{NULL,LN_rc4,NID_rc4,OBJ_rc4,0},
	{NULL,LN_rsaEncryption,NID_rsaEncryption,OBJ_rsaEncryption,0},
	{NULL,LN_md2withRSAEncryption,
		NID_md2withRSAEncryption,OBJ_md2withRSAEncryption,0},
	{NULL,LN_md5withRSAEncryption,
		NID_md5withRSAEncryption,OBJ_md5withRSAEncryption,0},
	{NULL,LN_pbeWithMD2AndDES_CBC,
		NID_pbeWithMD2AndDES_CBC,OBJ_pbeWithMD2AndDES_CBC,0},
	{NULL,LN_pbeWithMD5AndDES_CBC,
		NID_pbeWithMD5AndDES_CBC,OBJ_pbeWithMD5AndDES_CBC,0},
	{SN_commonName,LN_commonName,NID_commonName,OBJ_commonName,0},
	{SN_countryName,LN_countryName,NID_countryName,OBJ_countryName,0},
	{SN_localityName,LN_localityName,NID_localityName,OBJ_localityName,0},
	{SN_stateOrProcinceName,LN_stateOrProcinceName,
		NID_stateOrProcinceName,OBJ_stateOrProcinceName,0},
	{SN_organizationName,LN_organizationName,
		NID_organizationName,OBJ_organizationName,0},
	{SN_organizationalUnitName,LN_organizationalUnitName,
		NID_organizationalUnitName,OBJ_organizationalUnitName,0},
	{NULL,LN_rsa,NID_rsa,OBJ_rsa,0},
	{NULL,LN_X500,NID_X500,OBJ_X500,0},
	{NULL,LN_X509,NID_X509,OBJ_X509,0},
	{NULL,LN_pkcs7,NID_pkcs7,OBJ_pkcs7,0},
	{NULL,LN_pkcs7_data,NID_pkcs7_data,OBJ_pkcs7_data,0},
	{NULL,LN_pkcs7_signedData,NID_pkcs7_signedData,OBJ_pkcs7_signedData,0},
	{NULL,LN_pkcs7_envelopedData,NID_pkcs7_envelopedData,
		OBJ_pkcs7_envelopedData,0},
	{NULL,LN_pkcs7_signedAndEnvelopedData,NID_pkcs7_signedAndEnvelopedData,
		OBJ_pkcs7_signedAndEnvelopedData,0},
	{NULL,LN_pkcs7_digestData,NID_pkcs7_digestData,OBJ_pkcs7_digestData,0},
	{NULL,LN_pkcs7_encryptedData,NID_pkcs7_encryptedData,
		OBJ_pkcs7_encryptedData,0},
	{NULL,NULL,0,0}
	};

static LHASH *obj_h=NULL;
static LHASH *nid_h=NULL;
static LHASH *sn_h=NULL;
static LHASH *ln_h=NULL;
static int init=1;

static unsigned long nid_hash(a)
DER_OBJECT *a;
	{ return(a->nid); }

static int nid_cmp(a,b)
DER_OBJECT *a;
DER_OBJECT *b;
	{ return(a->nid-b->nid); }

static unsigned long obj_hash(a)
DER_OBJECT *a;
	{
	unsigned long ret=1;
	int i;

	for (i=0; i<a->num; i++)
		ret*=(a->values[i]+1);
	return(ret);
	}

static int obj_cmp(a, b)
DER_OBJECT *a;
DER_OBJECT *b;
	{
	int i,j;

	i=a->num-b->num;
	if (i != 0) return(i);
	for (i=0; i<a->num; i++)
		{
		j=a->values[i]-b->values[i];
		if (j != 0) return(j);
		}
	return(0);
	}

static unsigned long sn_hash(a)
DER_OBJECT *a;
	{ return(lh_strhash(a->sn)); }

static int sn_cmp(a,b)
DER_OBJECT *a;
DER_OBJECT *b;
	{ return(strcmp(a->sn,b->sn)); }

static unsigned long ln_hash(a)
DER_OBJECT *a;
	{ return(lh_strhash(a->ln)); }

static int ln_cmp(a,b)
DER_OBJECT *a;
DER_OBJECT *b;
	{ return(strcmp(a->ln,b->ln)); }

static int init_obj()
	{
	int i,j;
	DER_OBJECT *a,*b;

	if (obj_h == NULL) obj_h=lh_new(obj_hash,obj_cmp);
	if (nid_h == NULL) nid_h=lh_new(nid_hash,nid_cmp);
	if (sn_h == NULL) sn_h=lh_new(sn_hash,sn_cmp);
	if (ln_h == NULL) ln_h=lh_new(ln_hash,ln_cmp);
	if ((obj_h == NULL) || (nid_h == NULL) ||
		(sn_h == NULL) || (ln_h == NULL))
		{
		X509_errno=X509_ERR_OUT_OF_MEM;
		goto err;
		}

	for (i=0; objs[i].nid != 0; i++)
		{
		a=(DER_OBJECT *)DER_OBJECT_new();
		if (a == NULL) 
			{
			X509_errno=X509_ERR_DER;
			goto err;
			}
		a->sn=objs[i].sn;
		a->ln=objs[i].ln;
		a->nid=objs[i].nid;
		for (j=0; objs[i].nums[j] != 0; j++);
		a->num=j;
		a->values=(unsigned long *)malloc(sizeof(unsigned long *)*j);
		if (a->values == NULL)
			{
			X509_errno=X509_ERR_OUT_OF_MEM;
			goto err;
			}
		for (j=0; objs[i].nums[j] != 0; j++)
			a->values[j]=objs[i].nums[j];

		b=(DER_OBJECT *)lh_insert(obj_h,(char *)a);
		if (b != NULL)
			{
			X509_errno=X509_ERR_HIT_IN_OBJECT_STORAGE_VERY_BAD;
			goto err;
			}
		b=(DER_OBJECT *)lh_insert(nid_h,(char *)a);
		if (b != NULL)
			{
			X509_errno=X509_ERR_HIT_IN_NID_STORAGE_VERY_BAD;
			goto err;
			}
		if (a->sn != NULL)
			{
			b=(DER_OBJECT *)lh_insert(sn_h,(char *)a);
			if (b != NULL)
				{
				X509_errno=X509_ERR_HIT_IN_SN_STORAGE_VERY_BAD;
				goto err;
				}
			}
		if (a->ln != NULL)
			{
			b=(DER_OBJECT *)lh_insert(ln_h,(char *)a);
			if (b != NULL)
				{
				X509_errno=X509_ERR_HIT_IN_LN_STORAGE_VERY_BAD;
				goto err;
				}
			}
		}
	init=0;
	return(1);
err:
	abort();
	return(0);
	}


DER_OBJECT *X509_nid2obj(n)
int n;
	{
	DER_OBJECT o;

	if (init && !init_obj()) return(NULL);

	o.nid=n;
	return((DER_OBJECT *)lh_retrieve(nid_h,(char *)&o));
	}

int X509_obj2nid(a)
DER_OBJECT *a;
	{
	DER_OBJECT *o;

	if (init && !init_obj()) return(0);
	o=(DER_OBJECT *)lh_retrieve(obj_h,(char *)a);
	if (o == NULL) return(NID_undef);
	return(o->nid);
	}

char *X509_nid2sn(n)
int n;
	{
	DER_OBJECT o,*oo;

	if (init && !init_obj()) return(NULL);
	o.nid=n;
	oo=(DER_OBJECT *)lh_retrieve(nid_h,(char *)&o);
	if (oo == NULL) return(NULL);
	return(oo->sn);
	}

char *X509_nid2ln(n)
int n;
	{
	DER_OBJECT o,*oo;

	if (init && !init_obj()) return(NULL);
	o.nid=n;
	oo=(DER_OBJECT *)lh_retrieve(nid_h,(char *)&o);
	if (oo == NULL) return(NULL);
	return(oo->ln);
	}

DER_OBJECT *X509_dup_DER_OBJECT(o)
DER_OBJECT *o;
	{
	DER_OBJECT *r;
	int i;

	if (o == NULL) return(NULL);
	r=(DER_OBJECT *)DER_OBJECT_new();
	if (r == NULL)
		{
		X509_errno=X509_ERR_DER;
		return(NULL);
		}
	r->values=(unsigned long *)malloc(sizeof(unsigned long)*o->num);
	if (r->values == NULL)
		{
		X509_errno=X509_ERR_OUT_OF_MEM;
		return(NULL);
		}
	for (i=0; i<o->num; i++)
		r->values[i]=o->values[i];
	r->num=o->num;
	r->nid=o->nid;
	return(r);
	}

char *X509_oneline_X509_NAME(a)
X509_NAME *a;
	{
	int i,n,o=0,l=1,l1,l2;
	char *s;
	BUFFER *b;

	if (a == NULL) return("NO X509_NAME");
	o=0;
	b=buffer_new();
	if (b == NULL) { X509_errno=X509_ERR_OUT_OF_MEM; return(0); }
	for (i=0; i<a->num; i++)
		{
		n=X509_obj2nid(a->objects[i]);
		if (n == NID_undef)
			s="UNKNOWN";
		else
			{
			s=X509_nid2sn(n);
			if (s == NULL) s="UNKNOWN2";
			}
		l1=strlen(s);
		l2=a->values[i]->length;
		l+=1+l1+1+l2;
		if (!buffer_grow(b,(long)l))
			{
			X509_errno=X509_ERR_OUT_OF_MEM;
			return(0);
			}
		memcpy(&(b->data[o]),"/",1); o++;
		memcpy(&(b->data[o]),s,l1); o+=l1;
		memcpy(&(b->data[o]),"=",1); o++;
		memcpy(&(b->data[o]),a->values[i]->data,l2+1); o+=l2;
		}
	s=b->data;
	free(b);
	return(s);
err:
	buffer_free(b);
	return(NULL);
	}
