/* X509_lib.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "crypto.h"
#include "der.h"
#include "X509.h"

static char *version="\0X509 part of SSLeay v 0.4.3 15/06/95";

int DER_OBJECT_eq(a, b)
DER_OBJECT *a;
DER_OBJECT *b;
	{
	int i;

	if (a->num != b->num) return(0);
	for (i=a->num-1; i>=0; i--)
		if (a->values[i] != a->values[i]) return(0);
	a->nid=0;
	return(1);
	}

DER_BIT_STRING *DER_BIT_STRING_new()
	{
	DER_BIT_STRING *ret;

	ret=(DER_BIT_STRING *)malloc(sizeof(DER_BIT_STRING));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
	ret->length=0;
	ret->data=NULL;
	return(ret);
	}

DER_OBJECT *DER_OBJECT_new()
	{
	DER_OBJECT *ret;

	ret=(DER_OBJECT *)malloc(sizeof(DER_OBJECT));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
	ret->num=0;
	ret->values=NULL;
	ret->nid=0;
	ret->sn=NULL;
	ret->ln=NULL;
	return(ret);
	}

X509_ALGOR *X509_ALGOR_new()
	{
	X509_ALGOR *ret;

	ret=(X509_ALGOR *)malloc(sizeof(X509_ALGOR));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
	if ((ret->algorithm=DER_OBJECT_new()) == NULL) return(NULL);
	if ((ret->parameters=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509_NAME *X509_NAME_new()
	{
	X509_NAME *ret;

	ret=(X509_NAME *)malloc(sizeof(X509_NAME));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
	ret->num=0;
	ret->values=NULL;
	ret->types=NULL;
	ret->objects=NULL;
	return(ret);
	}

X509_VAL *X509_VAL_new()
	{
	X509_VAL *ret;

	ret=(X509_VAL *)malloc(sizeof(X509_VAL));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
	ret->notBefore=NULL;
	ret->notAfter=NULL;
	return(ret);
	}

X509_PUBKEY *X509_PUBKEY_new()
	{
	X509_PUBKEY *ret;

	ret=(X509_PUBKEY *)malloc(sizeof(X509_PUBKEY));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
	if ((ret->algor=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->public_key=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509_SIG *X509_SIG_new()
	{
	X509_SIG *ret;

	ret=(X509_SIG *)malloc(sizeof(X509_SIG));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
	if ((ret->algor=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->digest=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

X509_CINF *X509_CINF_new()
	{
	X509_CINF *ret;

	ret=(X509_CINF *)malloc(sizeof(X509_CINF));
	if (ret == NULL)
		{ DER_errno=DER_ERR_OUT_OF_MEM; return(NULL); }
/*	ret->version=0;/**/
	if ((ret->serialNumber=DER_BIT_STRING_new()) == NULL) return(NULL);
	if ((ret->signature=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->issuer=X509_NAME_new()) == NULL) return(NULL);
	if ((ret->validity=X509_VAL_new()) == NULL) return(NULL);
	if ((ret->subject=X509_NAME_new()) == NULL) return(NULL);
	if ((ret->key=X509_PUBKEY_new()) == NULL) return(NULL);
	return(ret);
	}

X509 *X509_new()
	{
	X509 *ret;

	ret=(X509 *)malloc(sizeof(X509));
	if (ret == NULL)
		{ X509_errno=X509_ERR_OUT_OF_MEM; return(NULL); }

	if ((ret->cert_info=X509_CINF_new()) == NULL) return(NULL);
	if ((ret->sig_alg=X509_ALGOR_new()) == NULL) return(NULL);
	if ((ret->signature=DER_BIT_STRING_new()) == NULL) return(NULL);
	return(ret);
	}

void DER_BIT_STRING_free(a)
DER_BIT_STRING *a;
	{
	if (a->data != NULL) free(a->data);
	free(a);
	}

void DER_OBJECT_free(a)
DER_OBJECT *a;
	{
	if (a->values != NULL) free(a->values);
	free(a);
	}

void X509_ALGOR_free(a)
X509_ALGOR *a;
	{
	DER_OBJECT_free(a->algorithm);
	DER_BIT_STRING_free(a->parameters);
	free(a);
	}

void X509_NAME_free(a)
X509_NAME *a;
	{
	int i;

	for (i=0; i<a->num; i++)
		{
		if (a->objects[i] != NULL) DER_OBJECT_free(a->objects[i]);
		if (a->values[i] != NULL) DER_BIT_STRING_free(a->values[i]);
		}
	if (a->objects != NULL) free(a->objects);
	if (a->types != NULL) free(a->types);
	if (a->values != NULL) free(a->values);
	free(a);
	}

void X509_VAL_free(a)
X509_VAL *a;
	{
	if (a->notBefore != NULL) free(a->notBefore);
	if (a->notAfter != NULL) free(a->notAfter);
	free(a);
	}

void X509_PUBKEY_free(a)
X509_PUBKEY *a;
	{
	X509_ALGOR_free(a->algor);
	if (a->public_key != NULL) DER_BIT_STRING_free(a->public_key);
	free(a);
	}

void X509_SIG_free(a)
X509_SIG *a;
	{
	X509_ALGOR_free(a->algor);
	if (a->digest != NULL) DER_BIT_STRING_free(a->digest);
	free(a);
	}

void X509_CINF_free(a)
X509_CINF *a;
	{
	X509_ALGOR_free(a->signature);
	X509_NAME_free(a->issuer);
	X509_VAL_free(a->validity);
	X509_NAME_free(a->subject);
	X509_PUBKEY_free(a->key);
	free(a);
	}

void X509_free(a)
X509 *a;
	{
	X509_CINF_free(a->cert_info);
	X509_ALGOR_free(a->sig_alg);
	DER_BIT_STRING_free(a->signature);
	free(a);
	}

