/* RSAref.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#define RSAref_MIN_BITS		508
#define RSAref_MAX_BITS		1024
#define RSAref_MAX_LEN		((RSAref_MAX_BITS+7)/8)
#define RSAref_MAX_PBITS	(RSAref_MAX_BITS+1)/2
#define RSAref_MAX_PLEN		((RSAref_MAX_PBITS+7)/8)

typedef struct RSArefPublicKey_st
	{
	unsigned int bits;
	unsigned char m[RSAref_MAX_LEN];
	unsigned char e[RSAref_MAX_LEN];
	} RSArefPublicKey;

typedef struct RSArefPrivateKey_st
	{
	unsigned int bits;
	unsigned char m[RSAref_MAX_LEN];
	unsigned char e[RSAref_MAX_LEN];
	unsigned char d[RSAref_MAX_LEN];
	unsigned char prime[2][RSAref_MAX_PLEN];/* p & q */
	unsigned char pexp[2][RSAref_MAX_PLEN];	/* dmp1 & dmq1 */
	unsigned char coef[RSAref_MAX_PLEN];	/* iqmp */
	} RSArefPrivateKey;

typedef struct RSARandomState_st
	{
	unsigned int needed;
	unsigned char state[16];
	unsigned int outputnum;
	unsigned char output[16];
	} RSARandomState;

#define RE_CONTENT_ENCODING 0x0400
#define RE_DATA 0x0401
#define RE_DIGEST_ALGORITHM 0x0402
#define RE_ENCODING 0x0403
#define RE_KEY 0x0404
#define RE_KEY_ENCODING 0x0405
#define RE_LEN 0x0406
#define RE_MODULUS_LEN 0x0407
#define RE_NEED_RANDOM 0x0408
#define RE_PRIVATE_KEY 0x0409
#define RE_PUBLIC_KEY 0x040a
#define RE_SIGNATURE 0x040b
#define RE_SIGNATURE_ENCODING 0x040c
#define RE_ENCRYPTION_ALGORITHM 0x040d
