/* PEM.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_PEM_H
#define HEADER_PEM_H

#define PEM_ERR_MALLOC_FAILURE		1
#define PEM_ERR_NO_START_LINE		2
#define PEM_ERR_BAD_END_LINE		3
#define PEM_ERR_DECODEING_ERROR		4
#define PEM_ERR_X509			5
#define PEM_ERR_RSA			6
#define PEM_ERR_READ_KEY		7
#define PEM_ERR_NOT_PROC_TYPE		8
#define PEM_ERR_NOT_ENCRYPTED		9
#define PEM_ERR_SHORT_HEADER		10
#define PEM_ERR_NOT_DEK_INFO		11
#define PEM_ERR_BAD_CBC_IV_CHARS	12
#define PEM_ERR_BAD_READ_PW_STRING	13
#define PEM_ERR_BAD_CBC_DECRYPT		14
#define PEM_ERR_UNSUPPORTED_ENCRYPTION	15
#define PEM_ERR_BASE64_LINE_TOO_LONG	16
#define PEM_ERR_BASE64_BAD_INPUT_CHAR	17
#define PEM_ERR_DER			18

extern int PEM_errno;

#ifdef PROTO
char *	PEM_error_string(int n);
int	PEM_do_header (char *header, int len, unsigned char *data);
void	PEM_set_getkey_callback(int (*a) (/* ??? */));
int	PEM_write_X509(FILE *fp, X509 *x);
int	PEM_read (FILE *fp, char **name, char **header, long int *len, unsigned char **data);
int	PEM_read_RSA(FILE *fp, RSA *x);
int	PEM_read_X509(FILE *fp, X509 *x);
int	PEM_write (FILE *fp, char *name, char *header, long int len, unsigned char *data);
int	PEM_write_RSA(FILE *fp, RSA *r, int enc, int klen, char *kstr);
#else
char *	PEM_error_string();
int	PEM_do_header ();
void	PEM_set_getkey_callback();
int	PEM_write_X509();
int	PEM_read ();
int	PEM_read_RSA();
int	PEM_read_X509();
int	PEM_write ();
int	PEM_write_RSA();
#endif

#endif
