/* rc4_enc.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include "rc4.h"

static char *version="\0RC4 part of SSLeay v 0.4.3 15/06/95";

/* RC4 as implemented from a posting from
 * Newsgroups: sci.crypt
 * From: sterndark@netcom.com (David Sterndark)
 * Subject: RC4 Algorithm revealed.
 * Message-ID: <sternCvKL4B.Hyy@netcom.com>
 */

void RC4_set_key(key, len, data)
RC4_KEY *key;
int len;
register unsigned char *data;
	{
        register RC4_INT tmp;
        register unsigned int id1,id2;
        register RC4_INT *d;
        int i;
        
        d=&(key->data[0]);
	for (i=0; i<256; i++)
		d[i]=i;
        key->x = 0;     
        key->y = 0;     
        id1=id2=0;     
        for (i=0; i < 256; i++)      
		{               
		id2 = (data[id1] + d[i] + id2) & 0xff;                
		tmp=d[i]; d[i]=d[id2]; d[id2]=tmp;
		id1=(id1+1)%len;  
		}       
	}
    
void RC4(key, len, indata, outdata)
RC4_KEY *key;
unsigned int len;
unsigned char *indata;
unsigned char *outdata;
	{
        register RC4_INT *d,tmp;
        register unsigned int x,y;
	unsigned int i;
        
        x=key->x;     
        y=key->y;     
        d=key->data;         

        for (i=0; i<len; i++)      
		{               
		x=((x+1)&0xff);
		tmp=d[x];
		y=(tmp+y)&0xff;
		d[x]=d[y];
		d[y]=tmp;
		outdata[i]=indata[i]^d[(d[x]+tmp)&0xff];
		}               
	key->x=x;     
	key->y=y;
	}
