/* md2test.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "md2.h"

char *test[]={
	"",
	"a",
	"abc",
	"message digest",
	"abcdefghijklmnopqrstuvwxyz",
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789",
	"12345678901234567890123456789012345678901234567890123456789012345678901234567890",
	NULL,
	};

char *ret[]={
	"8350e5a3e24c153df2275c9f80692773",
	"32ec01ec4a6dac72c0ab96fb34c0b5d1",
	"da853b0d3f88d99b30283a69e6ded6bb",
	"ab4f496bfb2a530b219ff33031fe06b0",
	"4e8ddff3650292ab5a4108c3aa47940b",
	"da33def2a42df13975352846c30338cd",
	"d5976f79d83d3a0dc9806c3c66f3efd8",
	};

#ifdef PROTO
static char *pt(unsigned char *md);
#else
static char *pt();
#endif

main()
	{
	int i,err=0;
	char **P,**R;
	char *p;

	P=test;
	R=ret;
	i=1;
	while (*P != NULL)
		{
		p=pt(MD2((unsigned long)strlen(*P),
			(unsigned char *)*P,NULL));
		if (strcmp(p,*R) != 0)
			{
			printf("error calculating MD2 on '%s'\n",*P);
			printf("got %s instead of %s\n",p,*R);
			err++;
			}
		else
			printf("test %d ok\n",i);
		i++;
		R++;
		P++;
		}
	exit(err);
	}

static char *pt(md)
unsigned char *md;
	{
	int i;
	static char buf[80];

	for (i=0; i<MD2_DIGEST_LENGTH; i++)
		sprintf(&(buf[i*2]),"%02x",md[i]);
	return(buf);
	}
