/* md2.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "md2.h"

#define BUFSIZE	1024*16

#ifdef PROTO
void do_fp(FILE *f);
void pt(unsigned char *md);
int read(int, void *, unsigned int);
void exit(int);
void perror(const char *);
#else
void do_fp();
void pt();
int read();
void exit();
void perror();
#endif

main(argc, argv)
int argc;
char **argv;
	{
	int i,err=0;
	FILE *IN;

	if (argc == 1)
		{
		do_fp(stdin);
		}
	else
		{
		for (i=1; i<argc; i++)
			{
			IN=fopen(argv[i],"r");
			if (IN == NULL)
				{
				perror(argv[i]);
				err++;
				continue;
				}
			printf("MD2(%s)= ",argv[i]);
			do_fp(IN);
			fclose(IN);
			}
		}
	exit(err);
	}

void do_fp(f)
FILE *f;
	{
	MD2_CTX c;
	unsigned char md[MD2_DIGEST_LENGTH];
	int fd,i;
	unsigned char buf[BUFSIZE];

	fd=fileno(f);
	MD2Init(&c);
	for (;;)
		{
		i=read(fd,buf,BUFSIZE);
		if (i <= 0) break;
		MD2Update(&c,buf,(unsigned long)i);
		}
	MD2Final(&(md[0]),&c);
	pt(md);
	}

void pt(md)
unsigned char *md;
	{
	int i;

	for (i=0; i<MD2_DIGEST_LENGTH; i++)
		printf("%02x",md[i]);
	printf("\n");
	}
