/* idea.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_IDEA_H
#define HEADER_IDEA_H

#define IDEA_ENCRYPT	1
#define IDEA_DECRYPT	0

#define IDEA_INT	unsigned int
#define IDEA_BLOCK	8
#define IDEA_KEY_LENGTH	16

typedef struct idea_key_st
	{
	IDEA_INT data[9][6];
	} IDEA_KEY_SCHEDULE;

#ifdef PROTO
void idea_encrypt(unsigned char *in, unsigned char *out, IDEA_KEY_SCHEDULE *ks);
void idea_encrypt_key(unsigned char *key, IDEA_KEY_SCHEDULE *ks);
void idea_decrypt_key(IDEA_KEY_SCHEDULE *ek, IDEA_KEY_SCHEDULE *dk);
void idea_cbc_encrypt(unsigned char *in, unsigned char *out,
	long int length, IDEA_KEY_SCHEDULE *ks, unsigned char *iv, int encrypt);
#else
void idea_encrypt();
void idea_encrypt_key();
void idea_decrypt_key();
void idea_cbc_encrypt();
#endif

#endif
