/* ssl.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_SSL_H 
#define HEADER_SSL_H 

/* Protocol Version Codes */
#define SSL_CLIENT_VERSION	0x0002
#define SSL_SERVER_VERSION	0x0002

/* Protocol Message Codes */
#define SSL_MT_ERROR			0
#define SSL_MT_CLIENT_HELLO		1
#define SSL_MT_CLIENT_MASTER_KEY	2
#define SSL_MT_CLIENT_FINISHED		3
#define SSL_MT_SERVER_HELLO		4
#define SSL_MT_SERVER_VERIFY		5
#define SSL_MT_SERVER_FINISHED		6
#define SSL_MT_REQUEST_CERTIFICATE	7
#define SSL_MT_CLIENT_CERTIFICATE	8

/* Error Message Codes */
#define SSL_PE_NO_CIPHER		0x0001
#define SSL_PE_NO_CERTIFICATE		0x0002
#define SSL_PE_BAD_CERTIFICATE		0x0004
#define SSL_PE_UNSUPPORTED_CERTIFICATE_TYPE 0x0006

/* Cipher Kind Values */
#define SSL_CK_RC4_128_WITH_MD5			0x01,0x00,0x80
#define SSL_CK_RC4_128_EXPORT40_WITH_MD5	0x02,0x00,0x80
#define SSL_CK_RC2_128_CBC_WITH_MD5		0x03,0x00,0x80
#define SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5	0x04,0x00,0x80
#define SSL_CK_IDEA_128_CBC_WITH_MD5		0x05,0x00,0x80
#define SSL_CK_DES_64_CBC_WITH_MD5		0x06,0x00,0x40
#define SSL_CK_DES_192_EDE3_CBC_WITH_MD5	0x07,0x00,0xc0
#define SSL_CK_NULL_64_WITH_MD5			0x08,0x00,0x80
#define SSL_CK_DES_64_CFB64_WITH_NULL		0x09,0x00,0x40

/* text strings for the ciphers */
#define SSL_TXT_RC4_128_WITH_MD5		"RC4-MD5"
#define SSL_TXT_RC4_128_EXPORT40_WITH_MD5	"EXP-RC4-MD5"
#define SSL_TXT_RC2_128_CBC_WITH_MD5		"RC2-MD5"
#define SSL_TXT_RC2_128_CBC_EXPORT40_WITH_MD5	"EXP-RC2-MD5"
#define SSL_TXT_IDEA_128_CBC_WITH_MD5		"CBC-IDEA-MD5"
#define SSL_TXT_DES_64_CBC_WITH_MD5		"CBC-DES-MD5"
#define SSL_TXT_DES_192_EDE3_CBC_WITH_MD5	"CBC3-DES-MD5"
#define SSL_TXT_NULL_64_WITH_MD5		"NULL-MD5"
#define SSL_TXT_DES_64_CFB64_WITH_NULL		"CFB-DES-NULL"

/* Certificate Type Codes */
#define SSL_CT_X509_CERTIFICATE			0x01

/* Authentication Type Code */
#define SSL_AT_MD5_WITH_RSA_ENCRYPTION		0x01

/* Upper/Lower Bounds */
#define SSL_MAX_MASTER_KEY_LENGTH_IN_BITS	256
#define SSL_MAX_SESSION_ID_LENGTH_IN_BYTES	16
#define SSL_MIN_RSA_MODULUS_LENGTH_IN_BYTES	64
#define SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER	32767 
#define SSL_MAX_RECORD_LENGTH_3_BYTE_HEADER	16383 /**/
/*#define SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER	5 
#define SSL_MAX_RECORD_LENGTH_3_BYTE_HEADER	1 /**/

typedef struct ssl_state_st
	{
	/* used by ssl_read */
	int fd;
	int version;	/* procol version */

	int read_ahead;
	int escape;
	int three_byte_header;
	int send;		/* direction of packet */
	int clear_text;	/* clear text */
	int hit;		/* reusing a previous session */

	/* non-blocking io info */
	int wpend_tot;
	char *wpend_data;

	int wpend_off;
	int wpend_len;
	int rpend_off;
	int rpend_len;

	/* buffer raw data */
	int rbuf_left;
	int rbuf_offs;
	unsigned char *rbuf;
	unsigned char *wbuf;

	/* used internally by ssl_read to talk to ssl_decode_record */
	unsigned char *packet;
	unsigned int packet_length;

	/* set by ssl_read */
	unsigned int length;
	unsigned int padding;
	unsigned int ract_data_length; /* Set when things are encrypted. */
	unsigned int wact_data_length; /* Set when things are decrypted. */
	unsigned char *mac_data;
	unsigned char *act_data;
	unsigned char *pad_data;

	/* crypto */
	int num_pref_cipher;
	char **pref_cipher;	/* char ** is malloced and the rest is
				 * on malloced block pointed to by
				 * perf_cipher[0] */
	char *crypt_state;	/* cryptographic state */
	unsigned char *read_key;
	unsigned char *write_key;

	/* conn info */
#ifdef HEADER_SSL_LOCL_H
	CONN *conn;
	CERT *cert;
#else
	char *conn;
	char *cert;
#endif

	int challenge_length;
	unsigned char *challenge;
	int conn_id_length;
	unsigned char *conn_id;

	/* packet specs */
	/* send is true for send; false for recieve */

	unsigned char *write_ptr;	/* used to point to the start due to
					 * 2/3 byte header. */

	unsigned long read_sequence;
	unsigned long write_sequence;

	/* special stuff */
	int trust_level;	/* not used yet */
	int free_peer;
	char *peer;		/* actually a X509 * */
	int verify_mode;	/* 0 don't care about verify failure.
				 * 1 fail if verify fails */
	int (*verify_callback)(); /* fail if callback returns 0 */
	} SSL;

#define SSL_VERIFY_NONE			0x00
#define SSL_VERIFY_PEER			0x01
#define SSL_VERIFY_FAIL_IF_NO_PEER_CERT	0x02

#define SSL_TRUST_NONE			0x00
#define SSL_TRUST_WARN			0x01
#define SSL_TRUST_OK			0x02

#define SSL_RWERR_BAD_WRITE_RETRY	(-2)
#define SSL_RWERR_BAD_MAC_DECODE	(-3)

SSL *SSL_new();
void SSL_free();
int SSL_read();
int SSL_write();

int SSL_connect();
int SSL_accept();

void SSL_set_fd();
int SSL_get_fd();
int SSL_set_pref_cipher();
char *SSL_get_pref_cipher();
char *SSL_get_cipher();

void SSL_set_verify();
void SET_certificate();

/* both need to be set */
int SSL_use_RSAPublicKey();
int SSL_use_certificate();

void SSL_flush_connections();

extern int SSL_errno;
char *SSL_error_string();
char *SSL_error_func_string();

/* tjh added these two dudes to enable external control
 * of debug and trace logging
 */
extern FILE *SSL_ERR;
extern FILE *SSL_LOG;

#endif /* HEADER_SSL_H */

