/* X509_obj.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_X509_OBJ_H
#define HEADER_X509_OBJ_H

#define NID_undef			0
#define NID_rsadsi			1
#define OBJ_rsadsi			1,2,840,113549
#define NID_pkcs			2
#define OBJ_pkcs			OBJ_rsadsi,1
#define NID_md2				3
#define OBJ_md2				OBJ_rsadsi,2,2
#define NID_md5				4
#define OBJ_md5				OBJ_rsadsi,2,5
#define NID_rc4				5
#define OBJ_rc4				OBJ_rsadsi,3,4
#define NID_rsaEncryption		6
#define OBJ_rsaEncryption		OBJ_pkcs,1,1
#define NID_md2withRSAEncryption	7
#define OBJ_md2withRSAEncryption	OBJ_pkcs,1,2
#define NID_md5withRSAEncryption	8
#define OBJ_md5withRSAEncryption	OBJ_pkcs,1,4
#define NID_pbeWithMD2AndDES_CBC	9
#define OBJ_pbeWithMD2AndDES_CBC	OBJ_pkcs,5,1
#define NID_pbeWithMD5AndDES_CBC	10
#define OBJ_pbeWithMD5AndDES_CBC	OBJ_pkcs,5,3
#define NID_X500			11
#define OBJ_X500			2,5
#define NID_X509			12
#define OBJ_X509			OBJ_X500,4

#define SN_commonName			"CN"
#define LN_commonName			"commonName"
#define NID_commonName			13
#define OBJ_commonName			OBJ_X509,3

#define SN_countryName			"C"
#define LN_countryName			"countryName"
#define NID_countryName			14
#define OBJ_countryName			OBJ_X509,6

#define SN_localityName			"L"
#define LN_localityName			"localityName"
#define NID_localityName		15
#define OBJ_localityName		OBJ_X509,7

#define SN_stateOrProcinceName		"SOP"
#define LN_stateOrProcinceName		"stateOrProcinceName"
#define NID_stateOrProcinceName		16
#define OBJ_stateOrProcinceName		OBJ_X509,8

#define SN_organizationName		"O"
#define LN_organizationName		"organizationName"
#define NID_organizationName		17
#define OBJ_organizationName		OBJ_X509,10

#define SN_organizationalUnitName	"OU"
#define LN_organizationalUnitName	"organizationalUnitName"
#define NID_organizationalUnitName	18
#define OBJ_organizationalUnitName	OBJ_X509,11

#define NID_rsa				19
#define OBJ_rsa				OBJ_X500,8,1,1

#endif
