/* X509_def.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "der.h"
#include "bn.h"
#include "PEM.h"
#include "X509.h"
#include "location.h"

char *X509_get_default_cert_area()
	{ return(SSL_CERT_AREA); }

char *X509_get_default_cert_dir()
	{ return(SSL_CERT_DIR); }

char *X509_get_default_cert_file()
	{ return(SSL_CERT_FILE); }

char *X509_get_default_cert_dir_env()
	{ return(SSL_CERT_DIR_ENV); }

char *X509_get_default_cert_file_env()
	{ return(SSL_CERT_FILE_ENV); }

int X509_set_default_verify_paths()
	{
	char *a,*b;

	if (!X509_load_verify_locations(SSL_CERT_FILE,SSL_CERT_DIR))
		{
		fprintf(stderr,"error loading default cert locations, these are\n");
		fprintf(stderr,"the directory %s\n",SSL_CERT_DIR);
		fprintf(stderr,"and the file %s\n",SSL_CERT_FILE);
		return(0);
		}
	a=(char *)getenv(SSL_CERT_FILE_ENV);
	b=(char *)getenv(SSL_CERT_DIR_ENV);
	if (!X509_load_verify_locations(a,b))
		{
		fprintf(stderr,"error loading cert locations, these are\n");
		if (a != NULL)
			{
			fprintf(stderr,"the file %s\n",SSL_CERT_FILE);
			fprintf(stderr,"which is specified by the %s environment variable\n",SSL_CERT_FILE_ENV);
			return(0);
			}

		if (b != NULL)
			{
			fprintf(stderr,"the directory %s\n",SSL_CERT_FILE);
			fprintf(stderr,"which is specified by the %s environment variable\n",SSL_CERT_DIR_ENV);
			return(0);
			}
		}	
	return(1);
	}

X509_load_verify_locations(file_env,dir_env)
char *file_env,*dir_env;
	{
	int i;
	struct stat st;
	char *str;

	str=file_env;
	if ((str != NULL) && (stat(str,&st) == 0))
		{
		i=X509_add_cert_file(str,X509_FILETYPE_PEM);
		if (!i) return(0);
		}	

	str=dir_env;
	if (str != NULL)
		{
		i=X509_add_cert_dir(str,X509_FILETYPE_PEM);
		if (!i) return(0);
		}
	return(1);
	}

