/* rc4test.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "rc4.h"

unsigned char keys[6][11]={
	{8,0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef},
	{8,0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef},
	{8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{4,0xef,0x01,0x23,0x45},
	{8,0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef},
	};

unsigned char data[6][11]={
	{8,0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef},
	{8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0},
	};

unsigned char output[6][11]={
	{0x75,0xb7,0x87,0x80,0x99,0xe0,0xc5,0x96},
	{0x74,0x94,0xc2,0xe7,0x10,0x4b,0x08,0x79},
	{0xde,0x18,0x89,0x41,0xa3,0x37,0x5d,0x3a},
	{0xd6,0xa1,0x41,0xa7,0xec,0x3c,0x38,0xdf,0xbd,0x61},
	{0},
	};

main()
	{
	int i,err=0;
	unsigned int j;
	unsigned char *p;
	RC4_KEY key;
	unsigned char buf[512],obuf[512];

	for (i=0; i<512; i++) buf[i]=0x01;

	for (i=0; i<4; i++)
		{
		RC4_set_key(&key,keys[i][0],&(keys[i][1]));
		RC4(&key,data[i][0],&(data[i][1]),obuf);
		if (memcmp(obuf,output[i],data[i][0]) != 0)
			{
			printf("error calculating RC4\n");
			printf("output:");
			for (j=0; j<data[i][0]; j++)
				printf(" %02x",obuf[j]);
			printf("\n");
			printf("expect:");
			p= &(output[i][0]);
			for (j=0; j<data[i][0]; j++)
				printf(" %02x",*(p++));
			printf("\n");
			err++;
			}
		else
			printf("test %d ok\n",i);
		}
	exit(err);
	}

