/* md5.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "md5.h"

#define BUFSIZE	1024*16

void do_fp();
void pt();
int read();
void exit();

main(argc,argv)
int argc;
char *argv[];
	{
	int i,err=0;
	FILE *IN;

	if (argc == 1)
		{
		do_fp(stdin);
		}
	else
		{
		for (i=1; i<argc; i++)
			{
			IN=fopen(argv[i],"r");
			if (IN == NULL)
				{
				perror(argv[i]);
				err++;
				continue;
				}
			printf("MD5(%s)= ",argv[i]);
			do_fp(IN);
			fclose(IN);
			}
		}
	exit(err);
	}

void do_fp(f)
FILE *f;
	{
	MD5_CTX c;
	unsigned char md[MD5_DIGEST_LENGTH];
	int fd;
	int i;
	unsigned char buf[BUFSIZE];

	fd=fileno(f);
	MD5Init(&c);
	for (;;)
		{
		i=read(fd,buf,BUFSIZE);
		if (i <= 0) break;
		MD5Update(&c,buf,(unsigned long)i);
		}
	MD5Final(&(md[0]),&c);
	pt(md);
	}

void pt(md)
unsigned char *md;
	{
	int i;

	for (i=0; i<MD5_DIGEST_LENGTH; i++)
		printf("%02x",md[i]);
	printf("\n");
	}

