/* ssl_trc.h */
/* Copyright (C) 1995 Tim Hudson (tjh@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Tim Hudson's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

/* ssl_trc.h    - trace routines */

#ifndef SSL_TRACE_H
#define SSL_TRACE_H

#ifdef NOT_ANSI
#define VAR_ANSI                /* select ANSI version by default */
#endif

#ifdef VAR_ANSI
/* ANSI version of a "portable" macro set for variable length args */
#ifndef __STDARG_H__
#include <stdarg.h>
#endif

#define VAR_PLIST(arg1type,arg1)    arg1type arg1, ...
#define VAR_PLIST2(arg1type,arg1,arg2type,arg2) arg1type arg1,arg2type arg2,...
#define VAR_ALIST
#define VAR_BDEFN(args,arg1type,arg1)   va_list args
#define VAR_BDEFN2(args,arg1type,arg1,arg2type,arg2)    va_list args
#define VAR_INIT(args,arg1type,arg1)    va_start(args,arg1);
#define VAR_INIT2(args,arg1type,arg1,arg2type,arg2) va_start(args,arg2);
#define VAR_ARG(args,type,arg)      arg=va_arg(args,type)
#define VAR_END(args)           va_end(args);

#else

/* K&R version of a "portable" macro set for variable length args */
#ifndef __VARARGS_H__
#include <varargs.h>
#endif

#define VAR_PLIST(arg1type,arg1)    va_alist
#define VAR_PLIST2(arg1type,arg1,arg2type,arg2) va_alist
#define VAR_ALIST           va_dcl
#define VAR_BDEFN(args,arg1type,arg1)   va_list args; arg1type arg1
#define VAR_BDEFN2(args,arg1type,arg1,arg2type,arg2)    va_list args; \
    arg1type arg1; arg2type arg2
#define VAR_INIT(args,arg1type,arg1)    va_start(args); \
    arg1=va_arg(args,arg1type);
#define VAR_INIT2(args,arg1type,arg1,arg2type,arg2) va_start(args); \
    arg1=va_arg(args,arg1type); arg2=va_arg(args,arg2type);
#define VAR_ARG(args,type,arg)      arg=va_arg(args,type)
#define VAR_END(args)           va_end(args);

#endif

#ifdef undef
extern void SSL_TRACE( VAR_PLIST( FILE *, fp ) );
extern int ssl_fprintf( VAR_PLIST( SSL *, ssl_con ) );
extern void SSL_TRACE();
extern int ssl_fprintf();
#endif

#ifdef undef
extern char *ssl_trace_prog;
extern int  ssl_trace_pid;
extern int  ssl_trace_count;
extern int  ssl_trace_enabled;
extern int  ssl_trace_autoflush;
extern int  ssl_trace_no_header;
#endif

#endif /* SSL_TRACE_H */
