/* ssl_rc4.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "rc4.h"
#include "md5.h"
#include "ssl_rc4.h"
#include "ssl_locl.h"

int ssl_enc_rc4_init(s,client)
SSL *s;
int client;
	{
	MD5_CTX md5s;
	unsigned char *md5d1,*md5d2;
	RC4_STATE *rc4s;
	CONN *c;

	if (s->crypt_state == NULL)
		s->crypt_state=(char *)malloc(sizeof(RC4_STATE));
	if (s->crypt_state == NULL) goto err;
	rc4s=(RC4_STATE *)s->crypt_state;

	c=s->conn;
	if (c->key_material != NULL) free(c->key_material);
	md5d1=c->key_material=(unsigned char *)malloc(MD5_DIGEST_LENGTH*2);
	if (c->key_material == NULL) goto err;
	c->key_material_length=MD5_DIGEST_LENGTH*2;
	md5d2=&(c->key_material[MD5_DIGEST_LENGTH]);
	
	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,"0",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d1,&md5s);

	MD5Init(&md5s);
	MD5Update(&md5s,s->conn->master_key,s->conn->master_key_length);
	MD5Update(&md5s,"1",1);
	MD5Update(&md5s,s->challenge,s->challenge_length);
	MD5Update(&md5s,s->conn_id,s->conn_id_length);
	MD5Final(md5d2,&md5s);

	if (client)
		{
		s->read_key= md5d1;
		s->write_key=md5d2;
		}
	else
		{
		s->write_key=md5d1;
		s->read_key= md5d2;
		}
	RC4_set_key(&(rc4s->rc4_read_ks),MD5_DIGEST_LENGTH,s->read_key);
	RC4_set_key(&(rc4s->rc4_write_ks),MD5_DIGEST_LENGTH,s->write_key);
	return(1);
err:
	SSL_errno=SSL_ERRCODE(SSL_F_SSL_ENC_RC4_INIT,SSL_R_OUT_OF_MEMORY);
	return(0);
	}

/* read/writes from s->mac_data using length for encrypt and decrypt.
 * it sets the s->padding, s->length and s->pad_data ptr if we
 * are encrypting */
void ssl_enc_rc4(s)
SSL *s;
	{
	RC4_STATE *rc4s;
	unsigned long l;

	rc4s=(RC4_STATE *)s->crypt_state;

	l=s->length;

	if (s->send)
		RC4(&(rc4s->rc4_write_ks),l,s->mac_data,s->mac_data);
	else
		RC4(&(rc4s->rc4_read_ks),l,s->mac_data,s->mac_data);
	}

