/* ssl_pkt.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <errno.h>
#include "ssl_locl.h"
#include "ssl_trc.h"

static int read_n();
static int decode_record();
static int unpack_record();
static void pack_record();

FILE *SSL_LOG;
FILE *SSL_ERR=stderr;

#ifdef PKT_DEBUG
void SSL_debug(file)
char *file;
	{
	SSL_LOG=fopen(file,"w");
	if (SSL_LOG == NULL)
		{
		perror(file);
		abort(1);
		}
	/* this is naughty ... each *character* goes out as a individual
	 * system call --tjh
	setbuf(SSL_LOG,NULL);
	 */
	}
#else
void SSL_debug(file)
char *file;
	{
	file=file;
	}
#endif

extern int errno;

/* SSL_read -
 * This routine will return 1-len bytes, decrypted etc if required.
 */
int SSL_read(s,buf,len)
SSL *s;
char *buf;
int len;
	{
	int n;

#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"SSL_read: start - read(%d)\n",len);
#endif
	s->send=0;
	/* data left over */
	if (s->ract_data_length > 0)
		{
#ifdef PKT_DEBUG
		SSL_TRACE(SSL_LOG,"SSL_read:old data left over, act_d_l=%d\n",
			s->ract_data_length);
#endif
		if (len > s->ract_data_length)
			n=s->ract_data_length;
		else
			n=len;

		bcopy(s->act_data,buf,n);
		s->ract_data_length-=n;
		s->act_data+=n;
#ifdef PKT_DEBUG
		SSL_TRACE(SSL_LOG,"SSL_read:old data left over, %d returned, %d left\n",
			n,s->ract_data_length);
#endif
		return(n);
		}
	else
		{
		n=read_n(s,2,SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER+2,0);
		if (n <= 0) return(n); /* ERROR */
#ifdef PKT_DEBUG
		SSL_TRACE(SSL_LOG,"SSL_read:got %d, p_l=%d, about to decode\n",n,
			s->packet_length);
		if (!s->clear_text)
                        {
                        SSL_TRACE(SSL_LOG,"ENC_READ_DATA_PACKET\n");
                        ssl_print_bytes(SSL_LOG,s->packet_length,s->packet);
                        SSL_TRACE(SSL_LOG,"\n");
                        }
#endif

		if ((n=decode_record(s)) <= 0) return(n);
		return(SSL_read(s,buf,len));
		}
	}

static int read_n(s,n,max,extend)
SSL *s;
unsigned int n,max,extend;
	{
	int i,off,new;

	if (!s->read_ahead)
		max=n;
	if (max > SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER+2)
		max=SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER+2;
	
	/* if there is stuff still in the buffer from a previous read,
	 * and there is more than we want, take some. */
	if (s->rbuf_left >= n)
		{
		if (extend)
			s->packet_length+=n;
		else
			{
			s->packet= &(s->rbuf[s->rbuf_offs]);
			s->packet_length=n;
			}
		s->rbuf_left-=n;
		s->rbuf_offs+=n;
		return(n);
		}

	/* Else we want more than we have.
	 * First, if there is some left or we want to extend */
	off=0;
	if ((s->rbuf_left != 0) || ((s->packet_length != 0) && extend))
		{
		new=s->rbuf_left;
		if (extend)
			{
			off=s->packet_length;
			if (s->packet != s->rbuf)
				bcopy(s->packet,s->rbuf,new+off);
			}
		else if (s->rbuf_offs != 0)
			{
			bcopy(&(s->rbuf[s->rbuf_offs]),s->rbuf,new);
			s->rbuf_offs=0;
			}
		s->rbuf_left=0;
		}
	else
		new=0;
	s->packet=s->rbuf;
	while (new < n)
		{
		i=read(s->fd,&(s->rbuf[off+new]),max-new);
		if (i <= 0) return(i);
		new+=i;
		}
	if (new > n)
		{
		s->rbuf_offs=n+off;
		s->rbuf_left=new-n;
		}
	else
		{
		s->rbuf_offs=0;
		s->rbuf_left=0;
		}
	if (extend)
		s->packet_length+=n;
	else
		s->packet_length=n;
	return(n);
	}

SSL_write(s,buf,len)
SSL *s;
char *buf;
int len;
	{
	int i;
	unsigned int olen,p,tot,l,n;

	s->send=1;

	/* first check if there is data from an encryption waiting to
	 * be sent - it must be sent because the other end is waiting
	 */
	if (s->wpend_len != 0)
		{
		if ((s->wpend_tot != len) || (s->wpend_data != buf))
			return(SSL_RWERR_BAD_WRITE_RETRY);
		tot=0;
		do	{
			i=write(s->fd,
				&(s->wpend_data[s->wpend_off]),
				s->wpend_len);
			if (i <= 0) return(i);
			s->wpend_off+=i;
			s->wpend_len-=i;
			} while (s->wpend_len > 0);
		return(s->wpend_tot);
		}
#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"SSL_write:start write %d bytes clear_text=%d\n",len,
		s->clear_text);
#endif
	olen=len;
	if (s->clear_text)
		{
		n=0;
		p=0;
		}
	else
		{
		n=s->conn->cipher->mac_size;
		i=(len+n)%s->conn->cipher->block_size;
		if (i == 0)
			p=0;
		else	p=s->conn->cipher->block_size-i;

		}
#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"SSL_write: mac_size=%d pad_size=%d\n",n,p);
#endif
	while (len > 0)
		{
		if (p == 0)	/* 2 byte header */
			{
			s->three_byte_header=0;
			if (len+n > SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER)
				{ /* multiple pks */
				l=SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER-n;
				if (!s->clear_text)
					{
					l=l-((l+n)%s->conn->cipher->block_size);
					p=0;
					}
#ifdef PKT_DEBUG
				SSL_TRACE(SSL_LOG,"SSL_write:part two_byte pkt l=%d\n",l);
#endif
				}
			else	/* one packet */
				{
				l=len;
#ifdef PKT_DEBUG
				SSL_TRACE(SSL_LOG,"SSL_write:full two_byte pkt l=%d\n",l);
#endif
				}
			}
		else		/* 3 byte header */
			{
			s->three_byte_header=1;
			if (len+n+p > SSL_MAX_RECORD_LENGTH_3_BYTE_HEADER)
				{ /* multiple pks */
				l=SSL_MAX_RECORD_LENGTH_3_BYTE_HEADER-n;
				l=l-((l+n)%s->conn->cipher->block_size);
				i=(l+n)%s->conn->cipher->block_size;
				if (i == 0)
					p=0;
				else
					p=s->conn->cipher->block_size-i;
#ifdef PKT_DEBUG
				SSL_TRACE(SSL_LOG,"SSL_write:part three_byte pkt l=%d p=%d\n",l,p);
#endif
				}
			else	/* one packet */
				{
				l=len;
#ifdef PKT_DEBUG
				SSL_TRACE(SSL_LOG,"SSL_write:full three_byte pkt l=%d p=%d\n",l,p);
#endif
				}
			}
		/* n is the number of MAC bytes
		 * l in the number of data bytes
		 * p is the number of padding bytes
		 * if p == 0, it is a 2 byte header */
		s->length=l;
		s->padding=p;
		s->mac_data= &(s->wbuf[3]);
		s->act_data= &(s->wbuf[3+n]);
		bcopy(buf,s->act_data,l);
		if (!s->clear_text)
			{
			s->wact_data_length=l+p;
			s->conn->cipher->hash(s,s->mac_data);
			s->length+=p+n;
			s->conn->cipher->crypt(s);
			}
		pack_record(s);
		INC32(s->write_sequence); /* expect next number */

#ifdef PKT_DEBUG
		SSL_TRACE(SSL_LOG,"SSL_write:packet_lenth=%d\n",s->packet_length);
		if (!s->clear_text)
			{
			SSL_TRACE(SSL_LOG,"ENC_WRITE_DATA_PACKET\n");
			ssl_print_bytes(SSL_LOG,s->packet_length,s->write_ptr);
			SSL_TRACE(SSL_LOG,"\n");
			}
#endif
		tot=0;
		while (tot < s->packet_length)
			{
			i=write(s->fd,&(s->write_ptr[tot]),
				s->packet_length-tot);
#ifdef PKT_DEBUG
			SSL_TRACE(SSL_LOG,"SSL_write:WRITE(%d) %d written\n",
				s->packet_length-tot,i);
			ssl_print_bytes(SSL_LOG,s->packet_length-tot,
				&(s->write_ptr[tot]));
#endif
			if (i <= 0)
				{
				/* we have been able to send only part of the
				 * message, return i, keep track of stuff to
				 * send, if we are called again we will send
				 * what we have left. */
				s->wpend_tot=olen;
				s->wpend_data=buf;

				s->wpend_off=tot;
				s->wpend_len=s->packet_length-tot;
				return(i);
				}
			tot+=i;
			}
		len-=l;
		buf+=l;
		}
	return(olen);
	}

static int decode_record(s)
SSL *s;
	{
	unsigned char mac[MAX_MAC_SIZE];
	int i;

#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"ssl_decode_record:start\n");
#endif
	/* we need to have at least 3 bytes */
	i=unpack_record(s);
	if (i <= 0) return(i);
#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"ssl_decode_record:pl=%d length=%d padding=%d clear_text=%d\n",
		s->packet_length,s->length,s->padding,s->clear_text);
#endif
	s->ract_data_length=s->length;
	if (!s->clear_text)
		{
#ifdef PKT_DEBUG
		SSL_TRACE(SSL_LOG,"ssl_decode_record:decrypt\n");
#endif

		s->conn->cipher->crypt(s);
		s->ract_data_length-=s->conn->cipher->mac_size;
		s->conn->cipher->hash(s,mac);
		s->ract_data_length-=s->padding;
		if (	(memcmp(mac,s->mac_data,s->conn->cipher->mac_size) != 0) ||
			(s->length%s->conn->cipher->block_size != 0))
			{
#ifdef PKT_DEBUG
			SSL_TRACE(SSL_ERR,"bad mac cmp: %d%%%d == 0\n",
				s->length,s->conn->cipher->block_size);
			ssl_print_bytes(SSL_ERR,
				s->conn->cipher->mac_size,s->mac_data);
			SSL_TRACE(SSL_ERR,"\n");
			ssl_print_bytes(SSL_ERR,s->conn->cipher->mac_size,mac);
			SSL_TRACE(SSL_ERR,"\n");
#endif
			return(SSL_RWERR_BAD_MAC_DECODE);
			}
		}
#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"ssl_decode_record:ract_data_length=%d\n",s->ract_data_length);
#endif
	INC32(s->read_sequence); /* expect next number */
	/* s->act_data is now available for processing */
	return(1);
	}

static int unpack_record(s)
SSL *s;
	{
	int n;
	register unsigned char *p;

#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"unpack_record:packet_length=%d\n",s->packet_length);
#endif
	p=s->packet;

	/* Do header */
	s->padding=0;
	s->escape=0;
	s->length=((p[0]<<8)|(p[1]));
	if ((p[0] & TWO_BYTE_BIT))		/* Two byte header? */
		{
		s->three_byte_header=0;
		s->length&=TWO_BYTE_MASK;	
		}
	else
		{
		s->three_byte_header=1;
		s->length&=THREE_BYTE_MASK;
		s->escape=((p[0] & SEC_ESC_BIT))?1:0; /* security escape */
		}
	p+=2;
	n=s->length+2+s->three_byte_header;
#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"unpack_record:three_byte=%d length=%d escape=%d\n",
		s->three_byte_header,s->length,s->escape);
	SSL_TRACE(SSL_LOG,"unpack_record:we have %d bytes but want %d\n",
		s->packet_length,n);
#endif
	if (n > s->packet_length)
		{
		n-=s->packet_length;
		n=read_n(s,n,n,1);
		if (n <= 0) return(n); /* ERROR */
		p= &(s->packet[2]);
		}

	if (s->three_byte_header)
		s->padding= *(p++);
	else	s->padding=0;

	/* Data portion */
	if (s->clear_text)
		{
		s->mac_data=p;
		s->act_data=p;
		s->pad_data=NULL;
		}
	else
		{
		s->mac_data=p;
		s->act_data= &p[s->conn->cipher->mac_size];
		s->pad_data= &p[s->conn->cipher->mac_size+s->length-s->padding];
		}
	return(1);
	}

static void pack_record(s)
SSL *s;
	{
	register unsigned char *p;

#ifdef PKT_DEBUG
	SSL_TRACE(SSL_LOG,"pack_record:three_byte=%d length=%d escape=%d padding=%d\n",
		s->three_byte_header,s->length,s->escape,s->padding);
#endif
	s->packet_length=s->length;
	if (s->three_byte_header) /* 3 byte header */
		{
		p=s->mac_data;
		p-=3;
		p[0]=(s->length>>8)&(THREE_BYTE_MASK>>8);
		if (s->escape) p[0]|=SEC_ESC_BIT;
		p[1]=s->length&0xff;
		p[2]=s->padding;
		s->packet_length+=3;
		}
	else
		{
		p=s->mac_data;
		p-=2;
		p[0]=((s->length>>8)&(TWO_BYTE_MASK>>8))|TWO_BYTE_BIT;
		p[1]=s->length&0xff;
		s->packet_length+=2;
		}
	s->write_ptr=p;
	}
