/* rsa_lib.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "bn.h"
#include "md5.h"
#include "X509.h"

static char *version="\0RSA part of SSLeay v 0.4.2 06/06/95";

RSA *RSA_new()
	{
	RSA *ret;

	ret=(RSA *)malloc(sizeof(RSA));
	if (ret == NULL)
		{
		RSA_errno=RSA_ERR_OUT_OF_MEM;
		return(NULL);
		}
	ret->n=NULL;
	ret->e=NULL;
	ret->d=NULL;
	ret->p=NULL;
	ret->q=NULL;
	ret->dmp1=NULL;
	ret->dmq1=NULL;
	ret->iqmp=NULL;
	ret->num=0;
	ret->buf=NULL;
	return(ret);
	}

void RSA_free(r)
RSA *r;
	{
	if (r->n != NULL) bn_free(r->n);
	if (r->e != NULL) bn_free(r->e);
	if (r->d != NULL) bn_free(r->d);
	if (r->p != NULL) bn_free(r->p);
	if (r->q != NULL) bn_free(r->q);
	if (r->dmp1 != NULL) bn_free(r->dmp1);
	if (r->dmq1 != NULL) bn_free(r->dmq1);
	if (r->iqmp != NULL) bn_free(r->iqmp);
	if (r->buf != NULL) free(r->buf);
	free(r);
	}

int RSA_public_encrypt(flen,from,to,rsa)
int flen;
unsigned char *from;
unsigned char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j,k;
	unsigned char *p;

	tos=bn_get_tos();
	i=bn_num_bytes(rsa->n);
	if (flen > (i-11))
		{
		RSA_errno=RSA_ERR_ENC_DATA_TO_BIG;
		goto err;
		}
	if ((rsa->num < i) || (rsa->buf == NULL))
		{
		if (rsa->buf != NULL) free(rsa->buf);
		rsa->buf=(unsigned char *)malloc(i+10);
		if (rsa->buf == NULL)
			{
			RSA_errno=RSA_ERR_OUT_OF_MEM;
			goto err;
			}
		}
	rsa->num=i;
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	p=rsa->buf;

	*(p++)=0;
	*(p++)=2; /* Public Key BT (Block Type) */

	/* padd out with non-zero random data */
	j=rsa->num-3-flen;
	MD5_rand(j,p);
	for (i=0; i<j; i++)
		{
		if (*p == '\0')
			do	{
				MD5_rand(1,p);
				} while (*p == '\0');
		p++;
		}
	*(p++)='\0';
	memcpy(p,from,flen);
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn(rsa->num,rsa->buf,f) == NULL) goto err;
	if (!bn_mod_exp(ret,f,rsa->e,rsa->n)) goto err;

	/* put in leading 0 bytes if the number is less than the
	 * length of the modulus */
	j=bn_num_bytes(ret);
	i=bn_bn2bin(ret,&(to[rsa->num-j]));
	for (k=0; k<(rsa->num-i); k++)
		to[k]=0;

	bn_set_tos(tos);
	bn_clean_up();
	return(rsa->num);
err:
	bn_set_tos(tos);
	bn_clean_up();
	return(0);
	}

int RSA_private_encrypt(flen,from,to,rsa)
int flen;
unsigned char *from;
unsigned char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j,k;
	unsigned char *p;

	tos=bn_get_tos();
	i=bn_num_bytes(rsa->n);
	if (flen > (i-11))
		{
		RSA_errno=RSA_ERR_ENC_DATA_TO_BIG;
		goto err;
		}
	if ((rsa->num < i) || (rsa->buf == NULL))
		{
		if (rsa->buf != NULL) free(rsa->buf);
		rsa->buf=(unsigned char *)malloc(i+10);
		if (rsa->buf == NULL)
			{
			RSA_errno=RSA_ERR_OUT_OF_MEM;
			goto err;
			}
		}
	rsa->num=i;
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	p=rsa->buf;

	*(p++)=0;
	*(p++)=1; /* Private Key BT (Block Type) */

	/* padd out with 0xff data */
	j=rsa->num-3-flen;
	for (i=0; i<j; i++)
		*(p++)=0xff;
	*(p++)='\0';
	memcpy(p,from,flen);
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn(rsa->num,rsa->buf,f) == NULL) goto err;
	if (	(rsa->p != NULL) &&
		(rsa->q != NULL) &&
		(rsa->dmp1 != NULL) &&
		(rsa->dmq1 != NULL) &&
		(rsa->iqmp != NULL))
		{ if (!RSA_mod_exp(ret,f,rsa)) goto err; }
	else
		{ if (!bn_mod_exp(ret,f,rsa->d,rsa->n)) goto err; }

	p=rsa->buf;
	i=bn_bn2bin(ret,p);

	/* put in leading 0 bytes if the number is less than the
	 * length of the modulus */
	j=bn_num_bytes(ret);
	i=bn_bn2bin(ret,&(to[rsa->num-j]));
	for (k=0; k<(rsa->num-i); k++)
		to[k]=0;

	bn_set_tos(tos);
	bn_clean_up();
	return(rsa->num);
err:
	bn_set_tos(tos);
	bn_clean_up();
	return(-1);
	}

int RSA_private_decrypt(flen,from,to,rsa)
unsigned int flen;
unsigned char *from;
char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j;
	unsigned char *p;

	tos=bn_get_tos();
	if (flen != rsa->num)
		{
		RSA_errno=RSA_ERR_DEC_DATA_NOT_EQ_TO_MOD_LENGTH;
		goto err;
		}
	/* make data into a big number */
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn(flen,from,f) == NULL) goto err;
	/* do the decrypt */
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	if (	(rsa->p != NULL) &&
		(rsa->q != NULL) &&
		(rsa->dmp1 != NULL) &&
		(rsa->dmq1 != NULL) &&
		(rsa->iqmp != NULL))
		{ if (!RSA_mod_exp(ret,f,rsa)) goto err; }
	else
		{ if (!bn_mod_exp(ret,f,rsa->d,rsa->n)) goto err; }

	p=rsa->buf;
	i=bn_bn2bin(ret,p);

	/* BT must be 02 */
	if (*(p++) != 02)
		{
		RSA_errno=RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_02;
		goto err;
		}

	/* scan over padding data */
	j=rsa->num-2; /* one for type and one for the prepended 0. */
	for (i=0; i<j; i++)
		if (*(p++) == 0) break;
	if (i == j)
		{
		RSA_errno=RSA_ERR_DEC_NULL_BEFORE_BLOCK_MISSING;
		goto err;
		}
	if (i < 8)
		{
		RSA_errno=RSA_ERR_DEC_BAD_PAD_BYTE_COUNT;
		goto err;
		}

	/* skip over the '\0' */
	i++;	
	j-=i;

	/* output data */
	memcpy(to,p,j);
	bn_set_tos(tos);
	bn_clean_up();
	return(j);
err:
	bn_set_tos(tos);
	bn_clean_up();
	return(-1);
	}

int RSA_public_decrypt(flen,from,to,rsa)
int flen;
unsigned char *from;
char *to;
RSA *rsa;
	{
	BIGNUM *f,*ret;
	int tos,i,j;
	unsigned char *p;

	tos=bn_get_tos();
	if (flen != rsa->num)
		{
		RSA_errno=RSA_ERR_DEC_DATA_NOT_EQ_TO_MOD_LENGTH;
		goto err;
		}
	/* make data into a big number */
	f=bn_get_reg();
	if (f == NULL) goto err;
	if (bn_bin2bn(flen,from,f) == NULL) goto err;
	/* do the decrypt */
	ret=bn_get_reg();
	if (ret == NULL) goto err;
	if (!bn_mod_exp(ret,f,rsa->e,rsa->n)) goto err;

	p=rsa->buf;
	i=bn_bn2bin(ret,p);

	/* BT must be 01 */
	if (*(p++) != 01)
		{
		RSA_errno=RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_01;
		goto err;
		}

	/* scan over padding data */
	j=rsa->num-2; /* one for type and one for the prepended 0. */
	for (i=0; i<j; i++)
		{
		if (*p != 0xff) /* should decrypt to 0xff */
			{
			if (*p == 0)
				{ p++; break; }
			else	{
				RSA_errno=RSA_ERR_DEC_BAD_FF_HEADER;
				goto err;
				}
			}
		p++;
		}
	if (i == j)
		{
		RSA_errno=RSA_ERR_DEC_NULL_BEFORE_BLOCK_MISSING;
		goto err;
		}
	if (i < 8)
		{
		RSA_errno=RSA_ERR_DEC_BAD_PAD_BYTE_COUNT;
		goto err;
		}

	/* skip over the '\0' */
	i++;	
	j-=i;

	/* output data */
	memcpy(to,p,j);
	bn_set_tos(tos);
	bn_clean_up();
	return(j);
err:
	bn_set_tos(tos);
	bn_clean_up();
	return(-1);
	}

int RSA_mod_exp(r0,I,rsa)
BIGNUM *r0,*I;
RSA *rsa;
	{
	BIGNUM *r1,*m1;
	int tos;

	tos=bn_get_tos();

	m1=bn_get_reg();
	r1=bn_get_reg();
	if ((m1 == NULL) || (r1 == NULL)) goto err;

	if (!bn_mod(r1,I,rsa->q)) goto err;
	if (!bn_mod_exp(m1,r1,rsa->dmq1,rsa->q)) goto err;

	if (!bn_mod(r1,I,rsa->p)) goto err;
	if (!bn_mod_exp(r0,r1,rsa->dmp1,rsa->p)) goto err;

	if (!bn_add(r1,r0,rsa->p)) goto err;
	if (!bn_sub(r0,r1,m1)) goto err;

	if (!bn_mul(r1,r0,rsa->iqmp)) goto err;
	if (!bn_mod(r0,r1,rsa->p)) goto err;
	if (!bn_mul(r1,r0,rsa->q)) goto err;
	if (!bn_add(r0,r1,m1)) goto err;
	
	bn_set_tos(tos);
	return(1);
err:
	bn_set_tos(tos);
	return(0);
	}

