/* X509.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_X509_H
#define HEADER_X509_H

#ifdef HEADER_DER_H
typedef struct AlgorithmIdentifier_st
	{
	DER_OBJECT *algorithm;
	DER_BIT_STRING *parameters;
	} X509_ALGOR;

typedef struct Name_st
	{
	int num;
	DER_OBJECT **objects;
	int *types;
	DER_BIT_STRING **values;
	} X509_NAME;

typedef struct Validity_st
	{
	char *notBefore;
	char *notAfter;
	} X509_VAL;

typedef struct subject_public_keyinfo_st
	{
	X509_ALGOR *algor;
	DER_BIT_STRING *public_key;
	} X509_PUBKEY;

typedef struct signature_st
	{
	X509_ALGOR *algor;
	DER_BIT_STRING *digest;
	} X509_SIG;

typedef struct CertificateInfo_st
	{
/*	DER_BIT_STRING version; /**/
	DER_BIT_STRING *serialNumber;
	X509_ALGOR *signature;
	X509_NAME *issuer;
	X509_VAL *validity;
	X509_NAME *subject;
	X509_PUBKEY *key;
	} X509_CINF;

typedef struct X509_certificate_st
	{
	X509_CINF *cert_info;
	X509_ALGOR *sig_alg;
	DER_BIT_STRING *signature;
	} X509;
#endif

#define TOKEN_ERROR				0
#define TOKEN_X509_CERTIFICATE_BEGIN		1
#define TOKEN_X509_CERTIFICATE_END		2
#define TOKEN_CERTIFICATE_BEGIN			3
#define TOKEN_CERTIFICATE_END			4
#define TOKEN_ALGORITHMIDENTIFIER_BEGIN		5
#define TOKEN_ALGORITHMIDENTIFIER_END		6
#define TOKEN_NAME_BEGIN			7
#define TOKEN_NAME_END				8
#define TOKEN_VALIDITY_BEGIN			9
#define TOKEN_VALIDITY_END			10
#define TOKEN_SUBJECTPUBLICKEYINFO_BEGIN	11
#define TOKEN_SUBJECTPUBLICKEYINFO_END		12
#define TOKEN_RSAPUBLICKEY_BEGIN		13
#define TOKEN_RSAPUBLICKEY_END			14
#define TOKEN_RSAPRIVATEKEY_BEGIN		15
#define TOKEN_RSAPRIVATEKEY_END			16

#define STRING_X509_CERTIFICATE_BEGIN		"X.509-Certificate begin"
#define STRING_X509_CERTIFICATE_END		"X.509-Certificate end"
#define STRING_CERTIFICATE_BEGIN		"CertificteInfo begin"
#define STRING_CERTIFICATE_END			"CertificteInfo end"
#define STRING_NAME_BEGIN			"Name begin"
#define STRING_NAME_END				"Name end"
#define STRING_VALIDITY_BEGIN			"Validity begin"
#define STRING_VALIDITY_END			"Validity end"
#define STRING_SUBJECTPUBLICKEYINFO_BEGIN	"SubjectPublicKeyInfo begin"
#define STRING_SUBJECTPUBLICKEYINFO_END		"SubjectPublicKeyInfo end"
#define STRING_ALGORITHMIDENTIFIER_BEGIN	"AlgorithmIdentifier begin"
#define STRING_ALGORITHMIDENTIFIER_END		"AlgorithmIdentifier end"
#define STRING_RSAPRIVATEKEY_BEGIN		"RSAPrivateKey begin"
#define STRING_RSAPRIVATEKEY_END		"RSAPrivateKey end"
#define STRING_RSAPUBLICKEY_BEGIN		"RSAPublicKey begin"
#define STRING_RSAPUBLICKEY_END			"RSAPublicKey end"

#define X509_FILETYPE_PEM			1
#define X509_FILETYPE_TEXT			2
#define X509_FILETYPE_DER			3

typedef struct rsa_st
	{
#ifdef HEADER_BN_H
	BIGNUM *n;
	BIGNUM *e;
	BIGNUM *d;
	BIGNUM *p;
	BIGNUM *q;
	BIGNUM *dmp1;
	BIGNUM *dmq1;
	BIGNUM *iqmp;
#else
	char *n,*e,*d,*p,*q,*dmp1,*dmq1,*iqmp;
#endif
	int num;		/* number of bytes for n */
	unsigned char *buf;	/* buffer that is n bytes long */
	} RSA;

RSA *RSA_new();
RSA *RSA_generate_key();

/* next 4 return -1 on error */
int RSA_public_encrypt();
int RSA_private_encrypt();
int RSA_public_decrypt();
int RSA_private_decrypt();
int RSA_mod_exp();
int RSA_bn_rand();

extern int RSA_errno;
char *RSA_error_string();
extern int X509_errno;
char *X509_error_string();

unsigned char *rsa_private2DER();
unsigned char *rsa_public2DER();

/*#define RSA_DEBUG /**/

#define X509_ERR_BAD_CERT_DECODE		1
#define X509_ERR_NO_ISSUER_CERT			2
#define X509_ERR_BAD_CERT_INIT			3
#define X509_ERR_OUT_OF_MEM			4
#define X509_ERR_CERT_ALREADY_IN_HASH_TABLE	5
#define X509_ERR_CERT_FILE_OPEN_ERROR		6
#define X509_ERR_DER				7
#define X509_ERR_PEM				8
#define X509_ERR_RSA				9
#define X509_ERR_HIT_IN_OBJECT_STORAGE_VERY_BAD	10
#define X509_ERR_HIT_IN_NID_STORAGE_VERY_BAD	11
#define X509_ERR_HIT_IN_SN_STORAGE_VERY_BAD	12
#define X509_ERR_HIT_IN_LN_STORAGE_VERY_BAD	13
#define X509_ERR_BAD_X509_FILETYPE		14

#define RSA_ERR_OUT_OF_MEM			1
#define RSA_ERR_DIV_BY_ZERO			2
#define RSA_ERR_NULL_ARG_TO_BN_EXPAND		3
#define RSA_ERR_INVERSE_MODN_NO_SOLUTION	4
#define RSA_ERR_BAD_BN_MODMUL_RECIP		5
#define RSA_ERR_ENC_DATA_TO_BIG			6
#define RSA_ERR_DEC_DATA_NOT_EQ_TO_MOD_LENGTH	7
#define RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_02	8
#define RSA_ERR_DEC_NULL_BEFORE_BLOCK_MISSING	9
#define RSA_ERR_DEC_BAD_PAD_BYTE_COUNT		10
#define RSA_ERR_DEC_BLOCK_TYPE_IS_NOT_01	11
#define RSA_ERR_DEC_BAD_FF_HEADER		12

#ifdef HEADER_DER_H
DER_BIT_STRING *DER_BIT_STRING_new();
DER_OBJECT *	DER_OBJECT_new();
X509_ALGOR *	X509_ALGOR_new();
X509_NAME *	X509_NAME_new();
X509_VAL *	X509_VAL_new();
X509_PUBKEY *	X509_PUBKEY_new();
X509_SIG *	X509_SIG_new();
X509_CINF *	X509_CINF_new();
X509 *		X509_new();
DER_OBJECT *	X509_dup_DER_OBJECT();
DER_OBJECT *	X509_nid2obj();
char *		X509_oneline_X509_NAME();
char *		X509_verify_error_string();
int 		X509_add_cert_file();
#endif

unsigned long X509_subject_name_hash();

#ifdef HEADER_DER_H
X509_NAME *X509_get_issuer_name();
X509_NAME *X509_get_subject_name();
X509 *X509_new_D2i_X509();
#else
char *X509_get_issuer_name();
char *X509_get_subject_name();
char *X509_new_D2i_X509();
#endif

int X509_verify();

#define	VERIFY_OK					0
#define	VERIFY_ERR_UNABLE_TO_GET_ISSUER			1
#define	VERIFY_ERR_UNABLE_TO_DECRYPT_SIGNATURE		2
#define	VERIFY_ERR_UNABLE_TO_DECODE_ISSUER_PUBLIC_KEY	3
#define	VERIFY_ERR_UNABLE_TO_UNPACK_SIGNATURE		4
#define	VERIFY_ERR_UNKNOWN_X509_SIG_ALGORITHM		5
#define	VERIFY_ERR_SIG_DIGEST_LENGTH_WRONG		6
#define	VERIFY_ERR_SIGNATURE_FAILURE			7
#define	VERIFY_ERR_CERT_NOT_YET_VALID			8
#define	VERIFY_ERR_CERT_HAS_EXPIRED			9
#define	VERIFY_ERR_ERROR_IN_NOT_BEFORE_FIELD		10
#define	VERIFY_ERR_ERROR_IN_NOT_AFTER_FIELD		11
#define	VERIFY_ERR_OUT_OF_MEM				12
#define	VERIFY_ERR_DEPTH_ZERO_SELF_SIGNED_CERT		13

#endif
