/* Buffer.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "X509.h"
#include "Buffer.h"

#define BUFFER_INC	4

static int num_buffers=0;
static int buf_tos=0;
static BUFFER **bufs=NULL;

void buffer_clean_up()
	{
	int i;

	for (i=buf_tos; i<num_buffers; i++)
		{
		memset(bufs[i]->data,0,bufs[i]->length);
		free(bufs[i]);
		}
	num_buffers=buf_tos;
	}

BUFFER *buffer_new()
	{
	BUFFER *ret;

	ret=(BUFFER *)malloc(sizeof(BUFFER));
	if (ret == NULL)
		{
		X509_errno=X509_ERR_OUT_OF_MEM;
		return(NULL);
		}
	ret->length=0;
	ret->data=NULL;
	return(ret);
	}

void buffer_free(a)
BUFFER *a;
	{
	if (a->data) free(a->data);
	free(a);
	}

int buffer_grow(str,len)
BUFFER *str;
long len;
	{
	char *ret;

	if (str->length >= len) return(len);
	if (str->data == NULL)
		ret=(char *)malloc(len);
	else
		ret=(char *)realloc(str->data,len);
	if (ret == NULL)
		{
		X509_errno=X509_ERR_OUT_OF_MEM;
		ret=str->data;
		len=0;
		}
	else
		{
		str->data=ret;
		str->length=len;
		}
	return(len);
	}

int buffer_get_tos()
	{
	return(buf_tos);
	}

void buffer_set_tos(a)
int a;
	{
	buf_tos=a;
	}

BUFFER *buffer_get_buf()
	{
	int i;
	BUFFER **bp;

	if (bufs == NULL)
		{
		num_buffers=0;
		bufs=(BUFFER **)malloc(sizeof(BUFFER *));
		if (bufs == NULL)
			{
			X509_errno=X509_ERR_OUT_OF_MEM;
			return(NULL);
			}
		buf_tos=0;
		}
	if (buf_tos >= num_buffers)
		{
		i=num_buffers;
		num_buffers+=BUFFER_INC;
		bp=(BUFFER **)realloc(bufs,sizeof(BUFFER *)*num_buffers);
		if (bp == NULL)
			{
			X509_errno=X509_ERR_OUT_OF_MEM;
			return(NULL);
			}
		bufs=bp;
		for (; i<num_buffers; i++)
			{
			bufs[i]=buffer_new();
			if (bufs[i] == NULL) return(NULL);
			}
		}
	return(bufs[buf_tos++]);
	}

