/* md5_rand.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "md5.h"

/*#define NORAND	1 /**/
/*#define PREDICT	1 /**/

#define STATE_SIZE	1024
static int state_num=0,state_index=0;
static char state[STATE_SIZE];
static unsigned char md[MD5_DIGEST_LENGTH];
static int count=0;

void MD5_rand_cleanup()
	{
	memset(state,0,1024);
	state_num=0;
	state_index=0;
	state_index=0;
	memset(md,0,MD5_DIGEST_LENGTH);
	count=0;
	}

void MD5_rand_seed(num,buf)
int num;
unsigned char *buf;
	{
	int i;
	char b[128];

#ifdef NORAND
	return;
#endif

	for (i=0; i<num; i++)
		{
		state[state_index++]^=*(buf++);
		if (state_index >= STATE_SIZE)
			{
			state_index=0;
			state_num=STATE_SIZE;
			}
		}
	if (state_index > state_num)
		state_num=state_index;
	/* turn the state info over a bit */
	MD5_rand(128,b);
	memset(b,0,128);
	}

void MD5_rand(num,buf)
int num;
unsigned char *buf;
	{
	int i;
	MD5_CTX m;

#ifdef PREDICT
	{
	static unsigned char val=0;

	for (i=0; i<num; i++)
		buf[i]=val++;
	return;
	}
#endif
	count++;
	MD5Init(&m);
	MD5Update(&m,(unsigned char *)&count,sizeof(count)); count++;
	MD5Update(&m,md,MD5_DIGEST_LENGTH/2);
	MD5Final(md,&m);

	while (num >= MD5_DIGEST_LENGTH/2)
		{
		MD5Init(&m);
		MD5Update(&m,(unsigned char *)&count,sizeof(count)); count++;
		MD5Update(&m,md,MD5_DIGEST_LENGTH/2);
		MD5Update(&m,buf,MD5_DIGEST_LENGTH/2);
		MD5Update(&m,&(state[state_index]),MD5_DIGEST_LENGTH/2);
		MD5Final(md,&m);
		for (i=MD5_DIGEST_LENGTH/2; i<MD5_DIGEST_LENGTH; i++)
			{
			state[state_index++]^=md[i];
			*(buf++)=md[i];
			}
		if ((state_index+MD5_DIGEST_LENGTH/2) > state_num)
			state_index=0;
		num-=MD5_DIGEST_LENGTH/2;
		}
	MD5Init(&m);
	MD5Update(&m,(unsigned char *)&count,sizeof(count)); count++;
	MD5Update(&m,md,MD5_DIGEST_LENGTH/2);
	MD5Update(&m,buf,(unsigned long)num);
	MD5Update(&m,&(state[state_index]),MD5_DIGEST_LENGTH/2);
	MD5Final(md,&m);
	for (i=MD5_DIGEST_LENGTH/2; i<(MD5_DIGEST_LENGTH/2+num); i++)
		{
		state[state_index++]^=md[i];
		*(buf++)=md[i];
		}
	if ((state_index+MD5_DIGEST_LENGTH/2) > state_num)
		state_index=0;
	}

