/* ideatest.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "idea.h"

unsigned char k[16]={
	0x01,0x00,0x02,0x00,0x03,0x00,0x04,0x00,
	0x05,0x00,0x06,0x00,0x07,0x00,0x08,0x00};

unsigned char in[8]={0x00,0x00,0x01,0x00,0x02,0x00,0x03,0x00};
unsigned char  c[8]={0xFB,0x11,0x2B,0xED,0x98,0x01,0xE5,0x6D};
unsigned char out[80];

char *text="Hello to all people out there";

main()
	{
	int i,j,err=0;
	IDEA_KEY_SCHEDULE key,dkey; 
	IDEA_INT a[4];
	unsigned char iv[8];


	idea_encrypt_key(k,&key);
	idea_encrypt(in,out,&key);
	if (memcmp(out,c,8) != 0)
		{
		printf("error encrypting\n");
		printf("got     :");
		for (i=0; i<8; i++)
			printf("%02X ",out[i]);
		printf("\n");
		printf("expected:");
		for (i=0; i<8; i++)
			printf("%02X ",c[i]);
		printf("\n");
		err=1;
		}
	else
		printf("encrypt ok\n");

	idea_decrypt_key(&key,&dkey);

	idea_encrypt(c,out,&dkey);
	if (memcmp(out,in,8) != 0)
		{
		printf("error decrypting\n");
		printf("got     :");
		for (i=0; i<8; i++)
			printf("%02X ",out[i]);
		printf("\n");
		printf("expected:");
		for (i=0; i<8; i++)
			printf("%02X ",in[i]);
		printf("\n");
		err=1;
		}
	else
		printf("decrypt ok\n");

	memcpy(iv,k,8);
	idea_cbc_encrypt(text,out,strlen(text)+1,&key,iv,1);
	memcpy(iv,k,8);
	idea_cbc_encrypt(out,out,8,&dkey,iv,0);
	idea_cbc_encrypt(&(out[8]),&(out[8]),strlen(text)+1-8,&dkey,iv,0);
	if (memcmp(text,out,strlen(text)+1) != 0)
		{
		printf("cbc idea bad\n");
		err=1;
		}
	else
		printf("cbc idea ok\n");

/*
idea_encrypt_key(k,&key);
for (i=0; i<1000000; i++)
	idea_encrypt(c,out,&key);
*/
	exit(err);
	}

