/* ssl_trc.c */
/* Copyright (C) 1995 Tim Hudson (tjh@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Tim Hudson's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

/* ssl_trc    - generic portable trace routines to make Eric's life easier
 *
 * 29-Apr-95 tjh    added ssl_fprintf
 * 21-Nov-94 tjh    original coding
 *
 */

#include <stdio.h>
#include <sys/types.h>
#include <time.h>

#include "ssl.h"
#include "ssl_trc.h"

static char *ssl_trace_prog="SSL";
static int ssl_trace_pid=0;
static int ssl_trace_count=0;
static int ssl_trace_enabled=1;
static int ssl_trace_autoflush=1;
static int ssl_trace_no_header=1;

void SSL_TRACE ( VAR_PLIST( FILE *, fp ) )
    VAR_ALIST
{
    VAR_BDEFN(args, FILE *, fp);
    char *format;

    static  struct  tm	    *tm_time;
    static  time_t  time_now = 0;
     
    VAR_INIT(args, FILE *, fp);
    VAR_ARG(args, char *, format);

    /* NULL file pointer is one way to disable the trace */
    if (fp==NULL)
	return;

    time_now = time ( (time_t *)0 );
    tm_time = localtime( &time_now );

    /* 0 means it isn't set or is no longer right */
    if (ssl_trace_pid==0)
	ssl_trace_pid=getpid();

    ssl_trace_count++;

    /* slip a nice header on the front of whatever we are tracing 
     * that makes it easy to extra and sort into time-sequenced data
     */
    if (!ssl_trace_no_header)
      fprintf(fp,"%s: [%06d/%09d] %d%02d%02d %02d%02d%02d ",
		      ssl_trace_prog,
		      ssl_trace_pid, ssl_trace_count,
		      tm_time->tm_year,
		      tm_time->tm_mon+1,
		      tm_time->tm_mday,
		      tm_time->tm_hour,
		      tm_time->tm_min,
		      tm_time->tm_sec
		      );

    vfprintf(fp,format,args);

    if (ssl_trace_autoflush)
	fflush(fp);

    VAR_END( args );
    return;
}

#ifndef LOCAL_TEST
int SSL_fprintf ( VAR_PLIST( SSL *, ssl_con ) )
    VAR_ALIST
{
    VAR_BDEFN(args, SSL *, ssl_con);
    FILE *fp;
    char *format;
    static char hugebuf[10240];        /* 10k in one chunk is the limit */

    VAR_INIT(args, SSL *, ssl_con);
    VAR_ARG(args, FILE *, fp);
    VAR_ARG(args, char *, format);

    if (ssl_con==NULL)
        return vfprintf(fp,format,args);

    hugebuf[0]='\0';

#ifdef sun
    _doprnt(hugebuf,format,args);
#else /* !sun */
    vsprintf(hugebuf,format,args);
#endif /* sun */

    SSL_write(ssl_con,hugebuf,strlen(hugebuf));

    VAR_END( args );
    return 0;
}
#endif /* !LOCAL_TEST */


#ifdef LOCAL_TEST

#include <stdio.h>

int
main(argc,argv)
int argc;
char *argv[];
{
    SSL_TRACE(stderr,"Hello there\n");
    SSL_TRACE(stderr,"Hello %s %d there %x\n","tjh",1,16);
    SSL_TRACE(NULL,"Should not see this\n");
    SSL_TRACE(stderr,"Should not see this (twice - only once)\n");

    fflush(stderr);

    exit(0);

}

#endif

