/* client.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/time.h> /* Needed under linux for FD_XXX */
#include <netinet/in.h>
#include "net.h"
#include "X509.h"
#include "ssl.h"

/*#define SSL_HOST_NAME	"www.netscape.com" /**/
/*#define SSL_HOST_NAME	"193.118.187.102" /**/
#define SSL_HOST_NAME	"localhost" /**/

/*#define TEST_CERT "client.PEM" */ /* no default cert. */

#define BUFSIZZ	40*1024

int verify_depth=0;
int verify_error=VERIFY_OK;

int verify_callback();
void set_cert_stuff();

void usage()
	{
	fprintf(stderr,"usage: client args\n");
	fprintf(stderr,"\n");
	fprintf(stderr," -host arg     - host or IP to connect to (default is %s)\n",SSL_HOST_NAME);
	fprintf(stderr," -port arg     - port to connect to (default is %d\n",PORT);
	fprintf(stderr," -verify arg   - turn on peer certificate verification\n");
	fprintf(stderr," -cert arg     - certificate file to use, PEM format assumed\n");
	fprintf(stderr," -key arg      - RSA file to use, PEM format assumed, in cert file if\n");
	fprintf(stderr,"                 not specified but cert fill is.\n");
	fprintf(stderr," -CApath arg   - PEM format directory of CA's\n");
	fprintf(stderr," -CAfile arg   - PEM format file of CA's\n");
	fprintf(stderr," -reconect     - Drop and re-make the connection with the same Session-ID\n");
	fprintf(stderr," -cipher       - prefered cipher to use, ':' seperated list of the following\n");
	fprintf(stderr,"                 RC4-MD5 EXP-RC4-MD5 CBC-DES-MD5 CBC3-DES-MD5 CFB-DES-NULL\n");
	}

main(argc,argv)
int argc;
char *argv[];
	{
	SSL *con,*con2;
	int s,i,width;
	char buf[BUFSIZZ];
	fd_set readfds;
	int port=PORT;
	char *host=SSL_HOST_NAME;
	char *cert_file=NULL,*key_file=NULL;
	char *CApath=NULL,*CAfile=NULL,*cipher=NULL;
	int reconnect=0,badop=0,verify=SSL_VERIFY_NONE;

	argc--;
	argv++;
	while (argc >= 1)
		{
		if	(strcmp(*argv,"-host") == 0)
			{
			if (argc-- < 1) goto bad;
			host= *(++argv);
			}
		else if	(strcmp(*argv,"-port") == 0)
			{
			if (argc-- < 1) goto bad;
			port=atoi(*(++argv));
			if (port == 0) goto bad;
			}
		else if	(strcmp(*argv,"-verify") == 0)
			{
			verify=SSL_VERIFY_PEER;
			if (argc-- < 1) goto bad;
			verify_depth=atoi(*(++argv));
			fprintf(stderr,"verify depth is %d\n",verify_depth);
			}
		else if	(strcmp(*argv,"-cert") == 0)
			{
			if (argc-- < 1) goto bad;
			cert_file= *(++argv);
			}
		else if	(strcmp(*argv,"-key") == 0)
			{
			if (argc-- < 1) goto bad;
			key_file= *(++argv);
			}
		else if	(strcmp(*argv,"-reconnect") == 0)
			{
			reconnect=1;
			}
		else if	(strcmp(*argv,"-CApath") == 0)
			{
			if (argc-- < 1) goto bad;
			CApath= *(++argv);
			}
		else if	(strcmp(*argv,"-CAfile") == 0)
			{
			if (argc-- < 1) goto bad;
			CAfile= *(++argv);
			}
		else if	(strcmp(*argv,"-cipher") == 0)
			{
			if (argc-- < 1) goto bad;
			cipher= *(++argv);
			}
		else
			{
			fprintf(stderr,"unknown option %s\n",*argv);
			badop=1;
			break;
			}
		argc--;
		argv++;
		}
	if (badop)
		{
bad:
		usage();
		exit(1);
		}

	if ((!X509_load_verify_locations(CAfile,CApath)) ||
		(!X509_set_default_verify_paths()))
		{
		fprintf(stderr,"X509_load_verify_locations error:%s\n",
			X509_error_string(X509_errno));
		exit(1);
		}

        SSL_debug("client.log");
	if (init_client(host,&s,SERVICE,port) == 0)
		{ perror("conecting"); exit(1); }
	fprintf(stderr,"CONNECTED\n");

	con=(SSL *)SSL_new();
	SSL_set_fd(con,s);
	SSL_set_verify(con,verify,verify_callback);

	if (cipher == NULL)
		SSL_set_pref_cipher(con,getenv("SSL_CIPHER"));
	else
		SSL_set_pref_cipher(con,cipher);

	set_cert_stuff(con,cert_file,key_file);

	if (!SSL_connect(con))
		{
		fprintf(stderr,"ERROR\n");
		if (verify_error != VERIFY_OK)
			{
			fprintf(stderr,"verify error:%s\n",
				X509_verify_error_string(verify_error));
			}
		else
			{
			fprintf(stderr,"SSL error:function is:%s\n",
				SSL_error_func_string(SSL_errno));
			fprintf(stderr,"         :error is   :%s\n",
				SSL_error_string(SSL_errno));
			}
		close(s);
		exit(1);
		}

	if (reconnect)
		{
		SSL_write(con,"bye\n",4);
		close(s); 

		if (init_client(host,&s,SERVICE,port) == 0)
			{ perror("conecting"); exit(1); }

		fprintf(stderr,"drop the connection and reconnect with the same session id\n");
		/* test a second connection */
		/* NOTE: It is a new SSL structure so we need to set the
		 * certificate and private key for this SSL structure */
		con2=SSL_new();
		SSL_set_fd(con2,s);
		SSL_copy_session_id(con2,con);
		set_cert_stuff(con2,cert_file,key_file);

		if (!SSL_connect(con2))
			{
			fprintf(stderr,"SSL error\n");
			if (verify_error != VERIFY_OK)
				{
				fprintf(stderr,"\tpeer cert verify failure\n");
				fprintf(stderr,"\t%s\n",
					X509_verify_error_string(verify_error));
				}
			else
				{
				fprintf(stderr,"function is:%s\n",
					SSL_error_func_string(SSL_errno));
				fprintf(stderr,"error is   :%s\n",
					SSL_error_string(SSL_errno));
				}
			SSL_free(con2);
			close(s);
			exit(1);
			}
		SSL_free(con);
		con=con2;
		}
	width=s+1;
	printf("CIPHER is %s\n",SSL_get_cipher(con));

	for (;;)
		{
		FD_ZERO(&readfds);
		FD_SET(fileno(stdin),&readfds);
		FD_SET(s,&readfds);
		select(width,&readfds,NULL,NULL,NULL);
		if (FD_ISSET(fileno(stdin),&readfds))
			{
			i=read(fileno(stdin),buf,BUFSIZZ);
			if ((i <= 0) || (buf[0] == 'Q'))
				{
				fprintf(stderr,"DONE\n");
				close(s);
				exit(0);
				}
			SSL_write(con,buf,i);
			}
		if (FD_ISSET(s,&readfds))
			{
			i=SSL_read(con,buf,BUFSIZZ);
			if (i<=0)
				{
				fprintf(stderr,"DONE\n");
				break;
				}
			write(fileno(stdout),buf,i);
			}
		}
	return(0);
	}

int init_client(server,sock,service,port)
char *server;
int *sock;
char *service;
int port;
	{
	struct servent ser;
	struct servent *serv;
	struct sockaddr_in them;
	struct hostent *host;
	struct protoent *prot;
	u_long ip_them;
	int s,i;

	if ((serv=getservbyname(service,PROTO)) == NULL)
		{
		serv= &ser;
		ser.s_port=htons(port);
		}

	host=gethostbyname(server);
	if (host == NULL)
		{
		int a,b,c,d;

		if (sscanf(server,"%d.%d.%d.%d",&a,&b,&c,&d) == 4)
			ip_them=(a<<24)|(b<<16)|(c<<8)|d;
		else
			{
			fprintf(stderr,"unable to get %s's ip address\n",
				server);
			return(0);
			}
		}
	else
		memcpy(&ip_them,host->h_addr_list[0],sizeof(ip_them));
	memset((char *)&them,0,sizeof(them));
	them.sin_family=AF_INET;
	them.sin_port=serv->s_port;
	them.sin_addr.s_addr=ip_them;

	prot=getprotobyname("tcp");
	if (prot == NULL)
		{
		fprintf(stderr,"unable to find tcp protocol number");
		return(0);
		}
	s=socket(AF_INET,SOCK_STREAM,prot->p_proto);
	if (s == -1) { fprintf(stderr,"socket:%m"); return(0); }

/*	ling.l_onoff=1;
	ling.l_linger=0;
	i=setsockopt(s,SOL_SOCKET,SO_LINGER,(char *)&ling,sizeof(ling));
	if (i < 0) { fprintf(stderr,"linger:%m"); exit(0); } /**/
	i=0;
	i=setsockopt(s,SOL_SOCKET,SO_KEEPALIVE,(char *)&i,sizeof(i));
	if (i < 0) { fprintf(stderr,"keepalive:%m"); exit(0); }

	if (connect(s,(struct sockaddr *)&them,sizeof(them)) == -1)
		{
		close(s);
		perror("connect");
		return(0);
		}
	*sock=s;
	return(1);
	}

/* duplicated in server.c and client.c */
int verify_callback(ok,xs,xi,depth,error)
int ok;
char *xs,*xi; /* should be X509 * but we can just have them as char *. */
int depth,error;
	{
	char *s;

	s=(char *)X509_oneline_X509_NAME(X509_get_subject_name(xs));
	if (s == NULL)
		{
		fprintf(stderr,"error:%s\n",X509_error_string(X509_errno));
		return(0);
		}
	fprintf(stderr,"depth=%d %s\n",depth,s);
	free(s);
	if (error == VERIFY_ERR_UNABLE_TO_GET_ISSUER)
		{
		s=(char *)X509_oneline_X509_NAME(X509_get_issuer_name(xs));
		if (s == NULL)
			{
			fprintf(stderr,"verify error:%s\n",
				X509_error_string(X509_errno));
			return(0);
			}
		fprintf(stderr,"issuer= %s\n",s);
		free(s);
		}
	if (!ok)
		{
		fprintf(stderr,"verify error:num=%d:%s\n",error,
			X509_verify_error_string(error));
		if (verify_depth <= depth)
			{
			ok=1;
			verify_error=VERIFY_OK;
			}
		else
			{
			ok=0;
			verify_error=error;
			}
		}
	fprintf(stderr,"verify return:%d\n",ok);
	return(ok);
	}

void set_cert_stuff(con,cert_file,key_file)
SSL *con;
char *cert_file,*key_file;
	{
	if (cert_file != NULL)
		{
		if (SSL_use_certificate_file(con,cert_file,
			X509_FILETYPE_PEM) <= 0)
			{
			fprintf(stderr,"unable to set certificate file\n");
			fprintf(stderr,"%s\n",SSL_error_string(SSL_errno));
			exit(1);
			}
		if (key_file == NULL) key_file=cert_file;
		if (SSL_use_RSAPrivateKey_file(con,key_file,
			X509_FILETYPE_PEM) <= 0)
			{
			fprintf(stderr,"unable to set public key file\n");
			fprintf(stderr,"%s\n",SSL_error_string(SSL_errno));
			exit(1);
			}
		}
	}
