/* ssl.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "des.h"
#include "rc4.h"
#include "ssl_locl.h"
#include "ssl_des.h"
#include "ssl_md5.h"
#include "ssl_rc4.h"
#include "ssl_rsa.h"
#include "ssl_null.h"

static char *version="\0SSLeay v 0.4.1";

CIPHER ssl_ciphers[]={
/* RC4_128_WITH_MD5 */
{	1,SSL_TXT_RC4_128_WITH_MD5,
	ssl_enc_rc4_init,ssl_enc_rc4,ssl_compute_md5_mac,
	16,16,1,0,SSL_CK_RC4_128_WITH_MD5,0},

/* RC4_128_EXPORT40_WITH_MD5 */
{	1,SSL_TXT_RC4_128_EXPORT40_WITH_MD5,
	ssl_enc_rc4_init,ssl_enc_rc4,ssl_compute_md5_mac,
	16,16,1,0,
	SSL_CK_RC4_128_EXPORT40_WITH_MD5,40},

/* RC2_128_CBC_WITH_MD5 */
{	0,SSL_TXT_RC2_128_CBC_WITH_MD5,
	NULL,NULL,NULL,
	0,0,0,0 ,SSL_CK_RC2_128_CBC_WITH_MD5,0},

/* RC2_128_CBC_EXPORT40_WITH_MD5 */
{	0,SSL_TXT_RC2_128_CBC_EXPORT40_WITH_MD5,
	NULL,NULL,NULL,
	0,0,0,0,
	SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5,40},

/* IDEA_128_CBC_WITH_MD5 */
{	0,SSL_TXT_IDEA_128_CBC_WITH_MD5,
	NULL,NULL,NULL,
	0,0,0,0,
	SSL_CK_IDEA_128_CBC_WITH_MD5,0},

/* DES_64_CBC_WITH_MD5 */
{	1,SSL_TXT_DES_64_CBC_WITH_MD5,
	ssl_enc_des_cbc_init,ssl_enc_des_cbc,ssl_compute_md5_mac,
	8,16,8,8,
	SSL_CK_DES_64_CBC_WITH_MD5,0},

/* DES_192_EDE3_CBC_WITH_MD5 */
{	1,SSL_TXT_DES_192_EDE3_CBC_WITH_MD5,
	ssl_enc_des_ede3_cbc_init,ssl_enc_des_ede3_cbc,ssl_compute_md5_mac,
	24,16,8,8,
	SSL_CK_DES_192_EDE3_CBC_WITH_MD5,0},

/* NULL_64_WITH_MD5 */
{	0,SSL_TXT_NULL_64_WITH_MD5,
	ssl_enc_null_init,ssl_enc_null,ssl_compute_md5_mac,
	8,16,0,0,
	SSL_CK_NULL_64_WITH_MD5,0},

/* DES_64_CFB64_WITH_NULL */
{	1,SSL_TXT_DES_64_CFB64_WITH_NULL,
	ssl_enc_des_cfb_init,ssl_enc_des_cfb,ssl_compute_null_mac,
	8,0,1,8,
	SSL_CK_DES_64_CFB64_WITH_NULL,0},

{ 	-1,"",NULL,NULL,NULL,0,0,0,0,0,0,0,0},
	};

static int num_pref_cipher=8;
static char *pref_cipher[]={
	SSL_TXT_DES_64_CBC_WITH_MD5,
	SSL_TXT_RC4_128_WITH_MD5,
	SSL_TXT_DES_192_EDE3_CBC_WITH_MD5,
	SSL_TXT_RC4_128_EXPORT40_WITH_MD5,
	SSL_TXT_DES_64_CFB64_WITH_NULL,
	NULL
	};

int SSL_errno=0;

void ssl_clear(s)
SSL *s;
	{
	s->version=SSL_SERVER_VERSION;

	s->read_ahead=0;
	s->wpend_tot=0;
	s->wpend_data=NULL;
	s->wpend_off=0;
	s->wpend_len=0;
	s->rpend_off=0;
	s->rpend_len=0;

	s->rbuf_left=0;
	s->rbuf_offs=0;

	s->packet=s->rbuf;
	s->packet_length=0;

	s->escape=0;
	s->length=0;
	s->padding=0;
	s->ract_data_length=0;
	s->wact_data_length=0;
	s->mac_data=NULL;
	s->act_data=NULL;
	s->pad_data=NULL;

	if (s->crypt_state != NULL) free(s->crypt_state);
	s->crypt_state=NULL;
	s->read_key=NULL;
	s->write_key=NULL;

	s->challenge_length=0;
	if (s->challenge != NULL) free(s->challenge);
	s->challenge=NULL;
	s->conn_id_length=0;
	if (s->conn_id != NULL) free(s->conn_id);
	s->conn_id=NULL;

	s->send=0;
	s->clear_text=1;
	s->hit=0;
	s->write_ptr=NULL;

	s->read_sequence=0;
	s->write_sequence=0;
	s->trust_level=0;
	if ((s->peer != NULL) && (s->free_peer))
		X509_free(s->peer);
	s->free_peer=0;
	s->peer=NULL;
	}

SSL *SSL_new()
	{
	SSL *s;

	s=(SSL *)malloc(sizeof(SSL));
	if (s == NULL) goto err;

	s->fd=-1;
	s->rbuf=(unsigned char *)malloc(SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER+2);
	if (s->rbuf == NULL) goto err;
	s->wbuf=(unsigned char *)malloc(SSL_MAX_RECORD_LENGTH_2_BYTE_HEADER+2);
	if (s->wbuf == NULL) goto err;
	s->num_pref_cipher=0;
	s->pref_cipher=NULL;
	s->crypt_state=NULL;
	s->challenge=NULL;
	s->conn_id=NULL;
	s->conn=NULL;
	s->cert=NULL;
	s->free_peer=0;
	s->verify_mode=SSL_VERIFY_NONE;
	s->verify_callback=NULL;

	ssl_clear(s);
	return(s);
err:
	SSL_errno=SSL_ERRCODE(SSL_F_SSL_NEW,SSL_R_OUT_OF_MEMORY);
	return(NULL);
	}

void SSL_free(s)
SSL *s;
	{
	/* add extra stuff */
	free(s->rbuf);
	free(s->wbuf);
	if (s->crypt_state != NULL) free(s->crypt_state);
	/* again, just let them linger around */
	/*if (s->conn != NULL) ssl_conn_free(s->conn); /**/
	if (s->cert != NULL) ssl_cert_free(s->cert);
	if (s->challenge != NULL) free(s->challenge);
	if (s->conn_id != NULL) free(s->conn_id);
	free((char *)s);
	}

#ifdef undef
void ssl_set_cipher_kind(s,type,null,key_bits)
SSL *s;
int type,null,key_bits;
	{
	if ((type > NUM_CIPHERS) || (!ssl_ciphers[type].valid))
		{
		/* BAD ERROR */
		SSL_TRACE(SSL_ERR,"bad cipher choice\n");
		abort();
		}
	s->conn->cipher=&(ssl_ciphers[type]);
	if (s->crypt_state != NULL)
		free(s->crypt_state);
	s->crypt_state=NULL;
	}
#endif

void ssl_print_bytes(f,n,b)
FILE *f;
int n;
char *b;
	{
	int i;
	static char *h="0123456789abcdef";

	/* NULL means don't trace/log */
        if (f == NULL)
	    return;

	for (i=0; i<n; i++)
		{
		fputc(h[(b[i]>>4)&0x0f],f);
		fputc(h[(b[i]   )&0x0f],f);
		fputc(' ',f);
		}
	}

void ssl_return_error(s)
SSL *s;
	{
	static unsigned char buf[1]={SSL_MT_ERROR};

	SSL_write(s,buf,1);
#ifdef ABORT_DEBUG
	abort(1);
#endif
	}


void SSL_set_fd(s,fd)
SSL *s;
int fd;
	{
	s->fd=fd;
	}

int SSL_get_fd(s)
SSL *s;
	{
	return(s->fd);
	}

int SSL_set_pref_cipher(s,str)
SSL *s;
char *str;
	{
	int i,j;
	char *p,**pp;

	if (str == NULL) return(1);
	if (s->pref_cipher != NULL)
		{
		free(s->pref_cipher[0]);
		free(s->pref_cipher);
		}

	p=str;
	i=(*p == '\0')?0:1;
	for (; *p; p++)
		if (*p == ':') i++;
	pp=(char **)malloc(sizeof(char *)*(i+1));
	if (pp == NULL) goto err;
	pp[0]=(char *)malloc(strlen(str)+1);
	if (pp == NULL) goto err;
	strcpy(pp[0],str);
	p=pp[0];
	j=1;
	for (;;)
		{
		while ((*p != ':') && (*p != '\0'))
			p++;
		if (*p == '\0') break;
		*p='\0';
		p++;
		pp[j++]=p;
		}
	pp[j]=NULL;
	s->num_pref_cipher=i;
	s->pref_cipher=pp;
	return(1);
err:
	SSL_errno=SSL_ERRCODE(SSL_F_SSL_NEW,SSL_R_OUT_OF_MEMORY);
	return(0);
	}

char *SSL_get_pref_cipher(s,n)
SSL *s;
int n;
	{
	if (n < s->num_pref_cipher)
		return(s->pref_cipher[n]);

	n-=s->num_pref_cipher;
	if (n < num_pref_cipher)
		return(pref_cipher[n]);
	return(NULL);
	}

char *SSL_get_cipher(s)
SSL *s;
	{
	if ((s->conn != NULL) && (s->conn->cipher != NULL))
		return(s->conn->cipher->name);
	return(NULL);
	}

int SSL_copy_session_id(to,from)
SSL *to,*from;
	{
	if (from->conn == NULL) return(0);
	to->conn=from->conn;
	from->conn->references++;
	return(1);
	}

void SSL_set_verify(s,mode,callback)
SSL *s;
int mode;
int (*callback)();
	{
	s->verify_mode=mode;
	s->verify_callback=callback;
	}

void SSL_set_read_ahead(s,yes)
SSL *s;
int yes;
	{
	s->read_ahead=yes;
	}

int SSL_get_read_ahead(s)
SSL *s;
	{
	return(s->read_ahead);
	}

int SSL_pending(s)
SSL *s;
	{
	return(s->rbuf_left);
	}

int SSL_set_timeout(s,t)
SSL *s;
int t;
	{
	if (s->conn == NULL) return(0);
	s->conn->timeout=t;
	return(1);
	}

int SSL_get_timeout(s)
SSL *s;
	{
	if (s->conn == NULL) return(0);
	return(s->conn->timeout);
	}

int SSL_get_time(s)
SSL *s;
	{
	if (s->conn == NULL) return(0);
	return(s->conn->time);
	}

void SSL_flush_connections()
	{
	/* not implemented yet */
	}

X509 *SSL_get_peer_certificate(s)
SSL *s;
	{
	/* not implemented yet */
	}
