/* verify.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#include <stdio.h>
#include "der.h"
#include "bn.h"
#include "PEM.h"
#include "X509.h"

static int cb();
static void check();

main(argc,argv)
int argc;
char *argv[];
	{
	int i;

	if (!X509_set_default_verify_paths()) exit(1);

	if (argc < 2) check(NULL);
	else
		for (i=1; i<argc; i++)
			check(argv[i]);
	exit(0);
	return(0);
	}

static void check(file)
char *file;
	{
	X509 *x;
	FILE *in;
	int i;

	if (file != NULL)
		{
		in=fopen(file,"r");
		if (in == NULL)
			{
			perror(file);
			exit(1);
			}
		}
	else
		in=stdin;

	x=(X509 *)X509_new();
	i=PEM_read_X509(in,x);
	if (!i)
		{
		fprintf(stdout,"%s: unable to load certificate file\n",
			file);
		if (PEM_errno == PEM_ERR_X509)
			fprintf(stdout,"X509 error %d\n",X509_errno);
		if (PEM_errno == PEM_ERR_RSA)
			fprintf(stdout,"RSA error %d\n",RSA_errno);
		if (PEM_errno == PEM_ERR_DER)
			fprintf(stdout,"DER error %d\n",DER_errno);
		X509_free(x);
		return;
		}
	fprintf(stdout,"%s: ",file);
	i=X509_verify(x,cb);
	if (i) fprintf(stdout,"OK\n");
	else fprintf(stderr,"X509_errno=%d\n",X509_errno);
	X509_free(x);
	return;
	}

static int cb(ok,xs,xi,depth,error)
int ok;
X509 *xs,*xi;
int depth,error;
	{
	if (!ok)
		{
		/* since we are just checking the certificates, it is
		 * ok if they are self signed. */
		if (error == VERIFY_ERR_DEPTH_ZERO_SELF_SIGNED_CERT)
			ok=1;
		else
			printf("error %d at %d:%s\n",error,depth,
				X509_verify_error_string(error));
		}
	return(ok);
	}

