/* bn.h */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the SSLeay distribution for more details.
 */

#ifndef HEADER_BN_H
#define HEADER_BN_H

/*#define LONGLONG /**/
#define RECP_MUL_MOD /**/

/* Only one for the following should be defined */
/*#define SIXTY_FOUR_BIT /**/
#define THIRTY_TWO_BIT /**/
/*#define SIXTEEN_BIT /**/

/* assuming long is 64bit - this is the DEC Alpha */
#ifdef SIXTY_FOUR_BIT
#define BN_ULLONG	unsigned long long
#define BN_ULONG	unsigned long
#define BN_LONG		long
#define BITS	128
#define BYTES	8
#define BITS2	64
#define BITS4	32
#define MASK2	(0xffffffffffffffffL)
#define MASK2l	(0x00000000ffffffffL)
#define MASK2h	(0xffffffff00000000L)
#define CBIT	((unsigned long long)0x10000000000000000LL)
#define TBIT	((unsigned long)0x8000000000000000L)
#define NOT_MASK2 ((unsigned long long)0xffffffffffffffff0000000000000000LL)
#endif

#ifdef THIRTY_TWO_BIT
#define BN_ULLONG	unsigned long long
#define BN_ULONG	unsigned long
#define BN_LONG		long
#define BITS	64
#define BYTES	4
#define BITS2	32
#define BITS4	16
#define MASK2	(0xffffffffL)
#define MASK2l	(0x0000ffffL)
#define MASK2h	(0xffff0000L)
#define CBIT	((unsigned long long)0x100000000LL)
#define TBIT	((unsigned long)0x80000000L)
#define NOT_MASK2 ((unsigned long long)0xffffffff00000000LL)
#endif

#ifdef SIXTEEN_BIT
#define BN_ULLONG	unsigned long
#define BN_ULONG	unsigned short
#define BN_LONG		short
#define BITS	32
#define BYTES	2
#define BITS2	16
#define BITS4	8
#define MASK2	(0xffffL)
#define MASK2l	(0x00ffL)
#define MASK2h	(0xff00L)
#define CBIT	((unsigned long)0x10000L)
#define TBIT	((unsigned int)0x8000L)
#define NOT_MASK2	((unsigned long)0xffff0000L)
#endif

#define DEFAULT_BITS	1200

typedef struct bignum_st
	{
	int top;	/* Index of last used d. */
	BN_ULONG *d;	/* Pointer to an array of 'BITS2' bit chunks. */
	/* The next are internal book keeping for bn_expand. */
	int max;	/* Size of the d array. */
	int neg;
	} BIGNUM;


int bn_num_bits();
BIGNUM *bn_new();
BIGNUM *bn_copy();
BIGNUM *bn_hex2bn();
BIGNUM *bn_bin2bn();
int bn_bn2bin();
int bn_sub();
int bn_add();
int bn_mod();
int bn_div();
int bn_mul();
BIGNUM *bn_get_reg();
int bn_get_tos();
void bn_set_tos();
BN_ULONG bn_mod_word();
int bn_MOD_init();
int bn_MOD();

#define bn_num_bytes(a)	((bn_num_bits(a)+7)/8)
#define bn_is_zero(a)	(((a)->top <= 1) && ((a)->d[0] == 0))
#define bn_is_one(a)	(((a)->top == 1) && ((a)->d[0] == 1))

#endif
